/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final Logger log = LoggerFactory.getLogger(ClientUtil.class);

    public static String toPrettyJson(JSONObject jsonObject) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    public static List<String> extractListByKey(JSONObject jsonObject, String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (jsonObject.has(key)) {
            JSONArray arrayOfValues = jsonObject.optJSONArray(key);
            if (arrayOfValues != null) {
                for (int i = 0; i < arrayOfValues.length(); ++i) {
                    result.add(arrayOfValues.getString(i));
                }
                return result;
            }
            String listString = jsonObject.optString(key);
            if (StringUtils.isNotBlank((String)listString)) {
                String[] arrayOfStringValues;
                for (String c : arrayOfStringValues = listString.split(" ")) {
                    if (!StringUtils.isNotBlank((String)c)) continue;
                    result.add(c);
                }
            }
        }
        return result;
    }

    public static CloseableHttpClient createHttpClient(String tlsVersion, String[] ciphers) {
        try {
            SSLContext sslContext = SSLContexts.createDefault();
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, new String[]{tlsVersion}, ciphers, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
            return HttpClients.custom().setSSLContext(sslContext).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        }
        catch (Exception e) {
            log.error("Error creating HttpClient with a custom TLS version and custom ciphers", (Throwable)e);
            return null;
        }
    }
}

