/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.uma;

import io.jans.as.client.service.ClientFactory;
import io.jans.as.client.uma.UmaMetadataService;
import io.jans.as.client.uma.UmaPermissionService;
import io.jans.as.client.uma.UmaResourceService;
import io.jans.as.client.uma.UmaRptIntrospectionService;
import io.jans.as.client.uma.UmaScopeService;
import io.jans.as.client.uma.UmaTokenService;
import io.jans.as.model.uma.UmaMetadata;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;

public class UmaClientFactory {
    private static final UmaClientFactory instance = new UmaClientFactory();
    private ApacheHttpClient4Engine engine = ClientFactory.instance().createEngine(true);

    private UmaClientFactory() {
    }

    public static UmaClientFactory instance() {
        return instance;
    }

    public UmaResourceService createResourceService(UmaMetadata metadata) {
        return this.createResourceService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaResourceService createResourceService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyWebTarget target = this.newClient(engine).target(new ResteasyUriBuilder().uri(metadata.getResourceRegistrationEndpoint()));
        return (UmaResourceService)target.proxy(UmaResourceService.class);
    }

    public UmaPermissionService createPermissionService(UmaMetadata metadata) {
        return this.createPermissionService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaPermissionService createPermissionService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyWebTarget target = this.newClient(engine).target(new ResteasyUriBuilder().uri(metadata.getPermissionEndpoint()));
        return (UmaPermissionService)target.proxy(UmaPermissionService.class);
    }

    public UmaRptIntrospectionService createRptStatusService(UmaMetadata metadata) {
        return this.createRptStatusService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaRptIntrospectionService createRptStatusService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyWebTarget target = this.newClient(engine).target(new ResteasyUriBuilder().uri(metadata.getIntrospectionEndpoint()));
        return (UmaRptIntrospectionService)target.proxy(UmaRptIntrospectionService.class);
    }

    public UmaMetadataService createMetadataService(String umaMetadataUri) {
        return this.createMetadataService(umaMetadataUri, (ClientHttpEngine)this.engine);
    }

    public UmaMetadataService createMetadataService(String umaMetadataUri, ClientHttpEngine engine) {
        ResteasyWebTarget target = this.newClient(engine).target(new ResteasyUriBuilder().uri(umaMetadataUri));
        return (UmaMetadataService)target.proxy(UmaMetadataService.class);
    }

    public UmaScopeService createScopeService(String scopeEndpointUri) {
        return this.createScopeService(scopeEndpointUri, (ClientHttpEngine)this.engine);
    }

    public UmaScopeService createScopeService(String scopeEndpointUri, ClientHttpEngine engine) {
        ResteasyWebTarget target = this.newClient(engine).target(new ResteasyUriBuilder().uri(scopeEndpointUri));
        return (UmaScopeService)target.proxy(UmaScopeService.class);
    }

    public UmaTokenService createTokenService(UmaMetadata metadata) {
        return this.createTokenService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaTokenService createTokenService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyWebTarget target = this.newClient(engine).target(new ResteasyUriBuilder().uri(metadata.getTokenEndpoint()));
        return (UmaTokenService)target.proxy(UmaTokenService.class);
    }

    public ResteasyClient newClient(ClientHttpEngine engine) {
        return new ResteasyClientBuilder().httpEngine(engine).build();
    }
}

