/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.model;

import io.jans.as.client.model.JwtState;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.model.util.Base64Util;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class SoftwareStatement {
    private static final Logger LOG = Logger.getLogger(JwtState.class);
    private SignatureAlgorithm signatureAlgorithm;
    private String keyId;
    private JSONObject claims;
    private String sharedKey;
    private AbstractCryptoProvider cryptoProvider;

    public SoftwareStatement(SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(signatureAlgorithm, cryptoProvider, null);
    }

    public SoftwareStatement(SignatureAlgorithm signatureAlgorithm, String sharedKey, AbstractCryptoProvider cryptoProvider) {
        this(signatureAlgorithm, cryptoProvider, sharedKey);
    }

    private SoftwareStatement(SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider, String sharedKey) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.cryptoProvider = cryptoProvider;
        this.sharedKey = sharedKey;
        this.claims = new JSONObject();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public JSONObject getClaims() {
        return this.claims;
    }

    public void setClaims(JSONObject claims) {
        this.claims = claims;
    }

    public String getEncodedJwt(JSONObject jwks) throws Exception {
        String encodedJwt = null;
        if (this.cryptoProvider == null) {
            throw new Exception("The Crypto Provider cannot be null.");
        }
        JSONObject headerJsonObject = this.headerToJSONObject();
        JSONObject payloadJsonObject = this.getClaims();
        String headerString = ClientUtil.toPrettyJson(headerJsonObject);
        String payloadString = ClientUtil.toPrettyJson(payloadJsonObject);
        String encodedHeader = Base64Util.base64urlencode((byte[])headerString.getBytes("UTF-8"));
        String encodedPayload = Base64Util.base64urlencode((byte[])payloadString.getBytes("UTF-8"));
        String signingInput = encodedHeader + "." + encodedPayload;
        String encodedSignature = this.cryptoProvider.sign(signingInput, this.keyId, this.sharedKey, this.signatureAlgorithm);
        encodedJwt = encodedHeader + "." + encodedPayload + "." + encodedSignature;
        return encodedJwt;
    }

    public String getEncodedJwt() throws Exception {
        return this.getEncodedJwt(null);
    }

    protected JSONObject headerToJSONObject() throws InvalidJwtException {
        JwtHeader jwtHeader = new JwtHeader();
        jwtHeader.setAlgorithm(this.signatureAlgorithm);
        jwtHeader.setKeyId(this.keyId);
        return jwtHeader.toJsonObject();
    }
}

