/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.fido.u2f;

import io.jans.as.client.fido.u2f.AuthenticationRequestService;
import io.jans.as.client.fido.u2f.RegistrationRequestService;
import io.jans.as.client.fido.u2f.U2fConfigurationService;
import io.jans.as.client.service.ClientFactory;
import io.jans.as.model.fido.u2f.U2fConfiguration;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;

public class FidoU2fClientFactory {
    private static final FidoU2fClientFactory instance = new FidoU2fClientFactory();
    private ApacheHttpClient4Engine engine = ClientFactory.instance().createEngine();

    private FidoU2fClientFactory() {
    }

    public static FidoU2fClientFactory instance() {
        return instance;
    }

    public U2fConfigurationService createMetaDataConfigurationService(String u2fMetaDataUri) {
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)u2fMetaDataUri));
        U2fConfigurationService proxy = (U2fConfigurationService)target.proxy(U2fConfigurationService.class);
        return proxy;
    }

    public AuthenticationRequestService createAuthenticationRequestService(U2fConfiguration metadataConfiguration) {
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadataConfiguration.getAuthenticationEndpoint()));
        AuthenticationRequestService proxy = (AuthenticationRequestService)target.proxy(AuthenticationRequestService.class);
        return proxy;
    }

    public RegistrationRequestService createRegistrationRequestService(U2fConfiguration metadataConfiguration) {
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadataConfiguration.getRegistrationEndpoint()));
        RegistrationRequestService proxy = (RegistrationRequestService)target.proxy(RegistrationRequestService.class);
        return proxy;
    }
}

