/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ciba.ping;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ciba.ping.PingCallbackRequest;
import io.jans.as.client.ciba.ping.PingCallbackResponse;
import io.jans.as.client.util.ClientUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.json.JSONObject;

public class PingCallbackClient
extends BaseClient<PingCallbackRequest, PingCallbackResponse> {
    private static final Logger LOG = Logger.getLogger(PingCallbackClient.class);
    private final boolean fapiCompatibility;

    public PingCallbackClient(String url, boolean fapiCompatibility) {
        super(url);
        this.fapiCompatibility = fapiCompatibility;
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public PingCallbackResponse exec() {
        if (this.fapiCompatibility) {
            this.setExecutor((ClientExecutor)this.getApacheHttpClient4ExecutorForMTLS());
        }
        this.initClientRequest();
        return this._exec();
    }

    private PingCallbackResponse _exec() {
        try {
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            this.clientRequest.header("Content-Type", (Object)((PingCallbackRequest)this.getRequest()).getContentType());
            if (StringUtils.isNotBlank((String)((PingCallbackRequest)this.getRequest()).getClientNotificationToken())) {
                this.clientRequest.header("Authorization", (Object)("Bearer " + ((PingCallbackRequest)this.getRequest()).getClientNotificationToken()));
            }
            JSONObject requestBody = ((PingCallbackRequest)this.getRequest()).getJSONParameters();
            this.clientRequest.body("application/json", (Object)requestBody.toString(4));
            this.clientResponse = this.clientRequest.post(String.class);
            this.setResponse(new PingCallbackResponse((ClientResponse<String>)this.clientResponse));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (PingCallbackResponse)this.getResponse();
    }

    private ApacheHttpClient4Executor getApacheHttpClient4ExecutorForMTLS() {
        String[] ciphers = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
        return new ApacheHttpClient4Executor((HttpClient)ClientUtil.createHttpClient("TLSv1.2", ciphers));
    }
}

