/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ciba.fcm;

import io.jans.as.client.BaseResponse;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseCloudMessagingResponse
extends BaseResponse {
    private static final Logger LOG = Logger.getLogger(FirebaseCloudMessagingResponse.class);
    private Long multicastId;
    private int success;
    private int failure;
    private List<Result> results;

    public FirebaseCloudMessagingResponse(ClientResponse<String> clientResponse) {
        super(clientResponse);
        String entity = (String)clientResponse.getEntity(String.class);
        this.setEntity(entity);
        this.setHeaders((MultivaluedMap<String, Object>)clientResponse.getMetadata());
        this.injectDataFromJson(entity);
    }

    public void injectDataFromJson(String p_json) {
        if (StringUtils.isNotBlank((String)p_json)) {
            try {
                JSONObject jsonObj = new JSONObject(p_json);
                if (jsonObj.has("multicast_id")) {
                    this.multicastId = jsonObj.getLong("multicast_id");
                }
                if (jsonObj.has("success")) {
                    this.success = jsonObj.getInt("success");
                }
                if (jsonObj.has("failure")) {
                    this.failure = jsonObj.getInt("failure");
                }
                if (jsonObj.has("results")) {
                    this.results = new ArrayList<Result>();
                    JSONArray resultsJsonArray = jsonObj.getJSONArray("results");
                    for (int i = 0; i < resultsJsonArray.length(); ++i) {
                        JSONObject resultJsonObject = resultsJsonArray.getJSONObject(i);
                        if (!resultJsonObject.has("message_id")) continue;
                        Result result = new Result(resultJsonObject.getString("message_id"));
                        this.results.add(result);
                    }
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    class Result {
        private String messageId;

        public Result(String messageId) {
            this.messageId = messageId;
        }
    }
}

