/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientResponse;

public class TokenClient
extends BaseClient<TokenRequest, TokenResponse> {
    private static final Logger LOG = Logger.getLogger(TokenClient.class);

    public TokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenResponse execAuthorizationCode(String code, String redirectUri, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.AUTHORIZATION_CODE));
        ((TokenRequest)this.getRequest()).setCode(code);
        ((TokenRequest)this.getRequest()).setRedirectUri(redirectUri);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execResourceOwnerPasswordCredentialsGrant(String username, String password, String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setUsername(username);
        ((TokenRequest)this.getRequest()).setPassword(password);
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execClientCredentialsGrant(String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.CLIENT_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execExtensionGrant(String grantTypeUri, String assertion, String clientId, String clientSecret) {
        GrantType grantType = GrantType.fromString((String)grantTypeUri);
        this.setRequest(new TokenRequest(grantType));
        ((TokenRequest)this.getRequest()).setAssertion(assertion);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execRefreshToken(String scope, String refreshToken, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.REFRESH_TOKEN));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setRefreshToken(refreshToken);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse exec() {
        this.initClientRequest();
        new ClientAuthnEnabler(this.clientRequest).exec((ClientAuthnRequest)this.request);
        this.clientRequest.header("Content-Type", (Object)((TokenRequest)this.request).getContentType());
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (((TokenRequest)this.getRequest()).getGrantType() != null) {
            this.clientRequest.formParameter("grant_type", (Object)((TokenRequest)this.getRequest()).getGrantType());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getCode())) {
            this.clientRequest.formParameter("code", (Object)((TokenRequest)this.getRequest()).getCode());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getCodeVerifier())) {
            this.clientRequest.formParameter("code_verifier", (Object)((TokenRequest)this.getRequest()).getCodeVerifier());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getRedirectUri())) {
            this.clientRequest.formParameter("redirect_uri", (Object)((TokenRequest)this.getRequest()).getRedirectUri());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getUsername())) {
            this.clientRequest.formParameter("username", (Object)((TokenRequest)this.getRequest()).getUsername());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getPassword())) {
            this.clientRequest.formParameter("password", (Object)((TokenRequest)this.getRequest()).getPassword());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getScope())) {
            this.clientRequest.formParameter("scope", (Object)((TokenRequest)this.getRequest()).getScope());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getAssertion())) {
            this.clientRequest.formParameter("assertion", (Object)((TokenRequest)this.getRequest()).getAssertion());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getRefreshToken())) {
            this.clientRequest.formParameter("refresh_token", (Object)((TokenRequest)this.getRequest()).getRefreshToken());
        }
        for (String key : ((TokenRequest)this.getRequest()).getCustomParameters().keySet()) {
            this.clientRequest.formParameter(key, (Object)((TokenRequest)this.getRequest()).getCustomParameters().get(key));
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getAuthReqId())) {
            this.clientRequest.formParameter("auth_req_id", (Object)((TokenRequest)this.getRequest()).getAuthReqId());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getDeviceCode())) {
            this.clientRequest.formParameter("device_code", (Object)((TokenRequest)this.getRequest()).getDeviceCode());
        }
        try {
            this.clientResponse = this.clientRequest.post(String.class);
            TokenResponse tokenResponse = new TokenResponse((ClientResponse<String>)this.clientResponse);
            tokenResponse.injectDataFromJson();
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (TokenResponse)this.getResponse();
    }
}

