/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.jans.as.client.BaseRequest;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.AsymmetricSignatureAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.model.register.ApplicationType;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterRequest
extends BaseRequest {
    private static final Logger log = Logger.getLogger(RegisterRequest.class);
    private String registrationAccessToken;
    private List<String> redirectUris;
    private List<String> claimsRedirectUris;
    private List<String> responseTypes;
    private List<GrantType> grantTypes;
    private ApplicationType applicationType;
    private List<String> contacts;
    private String clientName;
    private String logoUri;
    private String clientUri;
    private String policyUri;
    private String frontChannelLogoutUri;
    private Boolean frontChannelLogoutSessionRequired;
    private List<String> backchannelLogoutUris;
    private Boolean backchannelLogoutSessionRequired;
    private String tosUri;
    private String jwksUri;
    private String jwks;
    private String sectorIdentifierUri;
    private String idTokenTokenBindingCnf;
    private String tlsClientAuthSubjectDn;
    private Boolean allowSpontaneousScopes;
    private List<String> spontaneousScopes;
    private Boolean runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims;
    private Boolean keepClientAuthorizationAfterExpiration;
    private SubjectType subjectType;
    private Boolean rptAsJwt;
    private Boolean accessTokenAsJwt;
    private SignatureAlgorithm accessTokenSigningAlg;
    private SignatureAlgorithm idTokenSignedResponseAlg;
    private KeyEncryptionAlgorithm idTokenEncryptedResponseAlg;
    private BlockEncryptionAlgorithm idTokenEncryptedResponseEnc;
    private SignatureAlgorithm userInfoSignedResponseAlg;
    private KeyEncryptionAlgorithm userInfoEncryptedResponseAlg;
    private BlockEncryptionAlgorithm userInfoEncryptedResponseEnc;
    private SignatureAlgorithm requestObjectSigningAlg;
    private KeyEncryptionAlgorithm requestObjectEncryptionAlg;
    private BlockEncryptionAlgorithm requestObjectEncryptionEnc;
    private AuthenticationMethod tokenEndpointAuthMethod;
    private SignatureAlgorithm tokenEndpointAuthSigningAlg;
    private Integer defaultMaxAge;
    private Boolean requireAuthTime;
    private List<String> defaultAcrValues;
    private String initiateLoginUri;
    private List<String> postLogoutRedirectUris;
    private List<String> requestUris;
    private List<String> authorizedOrigins;
    private Integer accessTokenLifetime;
    private String softwareId;
    private String softwareVersion;
    private String softwareStatement;
    private BackchannelTokenDeliveryMode backchannelTokenDeliveryMode;
    private String backchannelClientNotificationEndpoint;
    private AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg;
    private Boolean backchannelUserCodeParameter;
    private List<String> additionalAudience;
    private List<String> scopes;
    private List<String> scope;
    private List<String> claims;
    private Map<String, String> customAttributes;
    private JSONObject jsonObject;
    private String httpMethod;

    public RegisterRequest() {
        this.setContentType("application/json");
        this.setMediaType("application/json");
        this.redirectUris = new ArrayList<String>();
        this.claimsRedirectUris = new ArrayList<String>();
        this.responseTypes = new ArrayList<String>();
        this.grantTypes = new ArrayList<GrantType>();
        this.contacts = new ArrayList<String>();
        this.defaultAcrValues = new ArrayList<String>();
        this.postLogoutRedirectUris = new ArrayList<String>();
        this.requestUris = new ArrayList<String>();
        this.authorizedOrigins = new ArrayList<String>();
        this.scopes = new ArrayList<String>();
        this.scope = new ArrayList<String>();
        this.claims = new ArrayList<String>();
        this.customAttributes = new HashMap<String, String>();
    }

    public RegisterRequest(ApplicationType applicationType, String clientName, List<String> redirectUris) {
        this();
        this.applicationType = applicationType;
        this.clientName = clientName;
        this.redirectUris = redirectUris;
    }

    public RegisterRequest(String registrationAccessToken) {
        this();
        this.registrationAccessToken = registrationAccessToken;
    }

    public String getTlsClientAuthSubjectDn() {
        return this.tlsClientAuthSubjectDn;
    }

    public void setTlsClientAuthSubjectDn(String tlsClientAuthSubjectDn) {
        this.tlsClientAuthSubjectDn = tlsClientAuthSubjectDn;
    }

    public Boolean getAllowSpontaneousScopes() {
        return this.allowSpontaneousScopes;
    }

    public void setAllowSpontaneousScopes(Boolean allowSpontaneousScopes) {
        this.allowSpontaneousScopes = allowSpontaneousScopes;
    }

    public List<String> getSpontaneousScopes() {
        return this.spontaneousScopes;
    }

    public void setSpontaneousScopes(List<String> spontaneousScopes) {
        this.spontaneousScopes = spontaneousScopes;
    }

    public List<String> getAdditionalAudience() {
        return this.additionalAudience;
    }

    public void setAdditionalAudience(List<String> additionalAudience) {
        this.additionalAudience = additionalAudience;
    }

    public Boolean getRunIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims() {
        return this.runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims;
    }

    public void setRunIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims(Boolean runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims) {
        this.runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims = runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims;
    }

    public Boolean getKeepClientAuthorizationAfterExpiration() {
        return this.keepClientAuthorizationAfterExpiration;
    }

    public void setKeepClientAuthorizationAfterExpiration(Boolean keepClientAuthorizationAfterExpiration) {
        this.keepClientAuthorizationAfterExpiration = keepClientAuthorizationAfterExpiration;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public List<String> getBackchannelLogoutUris() {
        return this.backchannelLogoutUris;
    }

    public void setBackchannelLogoutUris(List<String> backchannelLogoutUris) {
        this.backchannelLogoutUris = backchannelLogoutUris;
    }

    public Boolean getBackchannelLogoutSessionRequired() {
        return this.backchannelLogoutSessionRequired;
    }

    public void setBackchannelLogoutSessionRequired(Boolean backchannelLogoutSessionRequired) {
        this.backchannelLogoutSessionRequired = backchannelLogoutSessionRequired;
    }

    public String getFrontChannelLogoutUri() {
        return this.frontChannelLogoutUri;
    }

    public void setFrontChannelLogoutUri(String logoutUri) {
        this.frontChannelLogoutUri = logoutUri;
    }

    public Boolean getFrontChannelLogoutSessionRequired() {
        return this.frontChannelLogoutSessionRequired;
    }

    public void setFrontChannelLogoutSessionRequired(Boolean frontChannelLogoutSessionRequired) {
        this.frontChannelLogoutSessionRequired = frontChannelLogoutSessionRequired;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<String> getClaimsRedirectUris() {
        return this.claimsRedirectUris;
    }

    public void setClaimsRedirectUris(List<String> claimsRedirectUris) {
        this.claimsRedirectUris = claimsRedirectUris;
    }

    public List<ResponseType> getResponseTypes() {
        HashSet types = Sets.newHashSet();
        this.responseTypes.forEach(s -> types.addAll(ResponseType.fromString((String)s, (String)" ")));
        return Lists.newArrayList((Iterable)types);
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = ResponseType.toStringList(responseTypes);
    }

    public List<String> getResponseTypes_() {
        return this.responseTypes;
    }

    public void setResponseTypes_(List<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getIdTokenTokenBindingCnf() {
        return this.idTokenTokenBindingCnf;
    }

    public void setIdTokenTokenBindingCnf(String idTokenTokenBindingCnf) {
        this.idTokenTokenBindingCnf = idTokenTokenBindingCnf;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public Boolean getRptAsJwt() {
        return this.rptAsJwt;
    }

    public void setRptAsJwt(Boolean rptAsJwt) {
        this.rptAsJwt = rptAsJwt;
    }

    public Boolean getAccessTokenAsJwt() {
        return this.accessTokenAsJwt;
    }

    public void setAccessTokenAsJwt(Boolean accessTokenAsJwt) {
        this.accessTokenAsJwt = accessTokenAsJwt;
    }

    public SignatureAlgorithm getAccessTokenSigningAlg() {
        return this.accessTokenSigningAlg;
    }

    public void setAccessTokenSigningAlg(SignatureAlgorithm accessTokenSigningAlg) {
        this.accessTokenSigningAlg = accessTokenSigningAlg;
    }

    public SignatureAlgorithm getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(SignatureAlgorithm idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public SignatureAlgorithm getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(SignatureAlgorithm userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public SignatureAlgorithm getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(SignatureAlgorithm requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public KeyEncryptionAlgorithm getRequestObjectEncryptionAlg() {
        return this.requestObjectEncryptionAlg;
    }

    public void setRequestObjectEncryptionAlg(KeyEncryptionAlgorithm requestObjectEncryptionAlg) {
        this.requestObjectEncryptionAlg = requestObjectEncryptionAlg;
    }

    public BlockEncryptionAlgorithm getRequestObjectEncryptionEnc() {
        return this.requestObjectEncryptionEnc;
    }

    public void setRequestObjectEncryptionEnc(BlockEncryptionAlgorithm requestObjectEncryptionEnc) {
        this.requestObjectEncryptionEnc = requestObjectEncryptionEnc;
    }

    public AuthenticationMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(AuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public SignatureAlgorithm getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(SignatureAlgorithm tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public Boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public List<String> getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(List<String> defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public List<String> getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(List<String> requestUris) {
        this.requestUris = requestUris;
    }

    public List<String> getAuthorizedOrigins() {
        return this.authorizedOrigins;
    }

    public void setAuthorizedOrigins(List<String> authorizedOrigins) {
        this.authorizedOrigins = authorizedOrigins;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    public Integer getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(Integer accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public BackchannelTokenDeliveryMode getBackchannelTokenDeliveryMode() {
        return this.backchannelTokenDeliveryMode;
    }

    public void setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
    }

    public String getBackchannelClientNotificationEndpoint() {
        return this.backchannelClientNotificationEndpoint;
    }

    public void setBackchannelClientNotificationEndpoint(String backchannelClientNotificationEndpoint) {
        this.backchannelClientNotificationEndpoint = backchannelClientNotificationEndpoint;
    }

    public AsymmetricSignatureAlgorithm getBackchannelAuthenticationRequestSigningAlg() {
        return this.backchannelAuthenticationRequestSigningAlg;
    }

    public void setBackchannelAuthenticationRequestSigningAlg(AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
    }

    public Boolean getBackchannelUserCodeParameter() {
        return this.backchannelUserCodeParameter;
    }

    public void setBackchannelUserCodeParameter(Boolean backchannelUserCodeParameter) {
        this.backchannelUserCodeParameter = backchannelUserCodeParameter;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String p_httpMethod) {
        this.httpMethod = p_httpMethod;
    }

    public Map<String, String> getCustomAttributes() {
        return Collections.unmodifiableMap(this.customAttributes);
    }

    public void addCustomAttribute(String p_name, String p_value) {
        if (RegisterRequestParam.isCustomParameterValid((String)p_name)) {
            this.customAttributes.put(p_name, p_value);
        }
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        JsonApplier.getInstance().apply((Object)this, parameters);
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.redirectUris).toString());
        }
        if (this.claimsRedirectUris != null && !this.claimsRedirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.claimsRedirectUris).toString());
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.RESPONSE_TYPES.toString(), StringUtils.toJSONArray(this.responseTypes).toString());
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.GRANT_TYPES.toString(), StringUtils.toJSONArray(this.grantTypes).toString());
        }
        if (this.applicationType != null) {
            parameters.put(RegisterRequestParam.APPLICATION_TYPE.toString(), this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            parameters.put(RegisterRequestParam.CONTACTS.toString(), StringUtils.toJSONArray(this.contacts).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientName)) {
            parameters.put(RegisterRequestParam.CLIENT_NAME.toString(), this.clientName);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.logoUri)) {
            parameters.put(RegisterRequestParam.LOGO_URI.toString(), this.logoUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientUri)) {
            parameters.put(RegisterRequestParam.CLIENT_URI.toString(), this.clientUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.policyUri)) {
            parameters.put(RegisterRequestParam.POLICY_URI.toString(), this.policyUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tosUri)) {
            parameters.put(RegisterRequestParam.TOS_URI.toString(), this.tosUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwksUri)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), this.jwksUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwks)) {
            parameters.put(RegisterRequestParam.JWKS.toString(), this.jwks);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.sectorIdentifierUri)) {
            parameters.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            parameters.put(RegisterRequestParam.SUBJECT_TYPE.toString(), this.subjectType.toString());
        }
        if (this.rptAsJwt != null) {
            parameters.put(RegisterRequestParam.RPT_AS_JWT.toString(), this.rptAsJwt.toString());
        }
        if (this.accessTokenAsJwt != null) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString(), this.accessTokenAsJwt.toString());
        }
        if (this.accessTokenSigningAlg != null) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString(), this.accessTokenSigningAlg.toString());
        }
        if (this.idTokenSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.requestObjectSigningAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), this.requestObjectSigningAlg.getName());
        }
        if (this.requestObjectEncryptionAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), this.requestObjectEncryptionAlg.getName());
        }
        if (this.requestObjectEncryptionEnc != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), this.requestObjectEncryptionEnc.getName());
        }
        if (this.tokenEndpointAuthMethod != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), this.tokenEndpointAuthMethod.toString());
        }
        if (this.tokenEndpointAuthSigningAlg != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), this.tokenEndpointAuthSigningAlg.toString());
        }
        if (this.defaultMaxAge != null) {
            parameters.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), this.defaultMaxAge.toString());
        }
        if (this.requireAuthTime != null) {
            parameters.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), this.requireAuthTime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            parameters.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), StringUtils.toJSONArray(this.defaultAcrValues).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.initiateLoginUri)) {
            parameters.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), this.initiateLoginUri);
        }
        if (this.postLogoutRedirectUris != null && !this.postLogoutRedirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.postLogoutRedirectUris).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.frontChannelLogoutUri)) {
            parameters.put(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString(), this.frontChannelLogoutUri);
        }
        if (this.frontChannelLogoutSessionRequired != null) {
            parameters.put(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString(), this.frontChannelLogoutSessionRequired.toString());
        }
        if (this.backchannelLogoutUris != null && !this.backchannelLogoutUris.isEmpty()) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_LOGOUT_URI.toString(), StringUtils.toJSONArray(this.backchannelLogoutUris).toString());
        }
        if (this.backchannelLogoutSessionRequired != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_LOGOUT_SESSION_REQUIRED.toString(), this.backchannelLogoutSessionRequired.toString());
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REQUEST_URIS.toString(), StringUtils.toJSONArray(this.requestUris).toString());
        }
        if (this.authorizedOrigins != null && !this.authorizedOrigins.isEmpty()) {
            parameters.put(RegisterRequestParam.AUTHORIZED_ORIGINS.toString(), StringUtils.toJSONArray(this.authorizedOrigins).toString());
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            parameters.put(RegisterRequestParam.SCOPES.toString(), StringUtils.toJSONArray(this.scopes).toString());
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            parameters.put(RegisterRequestParam.SCOPE.toString(), StringUtils.implode(this.scope, (String)" "));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.idTokenTokenBindingCnf)) {
            parameters.put(RegisterRequestParam.ID_TOKEN_TOKEN_BINDING_CNF.toString(), this.idTokenTokenBindingCnf);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tlsClientAuthSubjectDn)) {
            parameters.put(RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString(), this.tlsClientAuthSubjectDn);
        }
        if (this.allowSpontaneousScopes != null) {
            parameters.put(RegisterRequestParam.ALLOW_SPONTANEOUS_SCOPES.toString(), this.allowSpontaneousScopes.toString());
        }
        if (this.spontaneousScopes != null && !this.spontaneousScopes.isEmpty()) {
            parameters.put(RegisterRequestParam.SPONTANEOUS_SCOPES.toString(), StringUtils.implode(this.spontaneousScopes, (String)" "));
        }
        if (this.runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims != null) {
            parameters.put(RegisterRequestParam.RUN_INTROSPECTION_SCRIPT_BEFORE_ACCESS_TOKEN_CREATION_AS_JWT_AND_INCLUDE_CLAIMS.toString(), this.runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims.toString());
        }
        if (this.keepClientAuthorizationAfterExpiration != null) {
            parameters.put(RegisterRequestParam.KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION.toString(), this.keepClientAuthorizationAfterExpiration.toString());
        }
        if (this.claims != null && !this.claims.isEmpty()) {
            parameters.put(RegisterRequestParam.CLAIMS.toString(), StringUtils.implode(this.claims, (String)" "));
        }
        if (this.accessTokenLifetime != null) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString(), this.accessTokenLifetime.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.softwareId)) {
            parameters.put(RegisterRequestParam.SOFTWARE_ID.toString(), this.softwareId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.softwareVersion)) {
            parameters.put(RegisterRequestParam.SOFTWARE_VERSION.toString(), this.softwareVersion);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.softwareStatement)) {
            parameters.put(RegisterRequestParam.SOFTWARE_STATEMENT.toString(), this.softwareStatement);
        }
        if (this.backchannelTokenDeliveryMode != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString(), this.backchannelTokenDeliveryMode.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.backchannelClientNotificationEndpoint)) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.toString(), this.backchannelClientNotificationEndpoint);
        }
        if (this.backchannelAuthenticationRequestSigningAlg != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString(), this.backchannelAuthenticationRequestSigningAlg.toString());
        }
        if (this.backchannelUserCodeParameter != null && this.backchannelUserCodeParameter.booleanValue()) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString(), this.backchannelUserCodeParameter.toString());
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang.StringUtils.isNotBlank((String)value)) continue;
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    public static RegisterRequest fromJson(String p_json, boolean authorizationRequestCustomAllowedParameters) throws JSONException {
        return RegisterRequest.fromJson(new JSONObject(p_json), authorizationRequestCustomAllowedParameters);
    }

    public static RegisterRequest fromJson(JSONObject requestObject, boolean authorizationRequestCustomAllowedParameters) throws JSONException {
        ArrayList<String> redirectUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.REDIRECT_URIS.toString())) {
            JSONArray redirectUrisJsonArray = requestObject.getJSONArray(RegisterRequestParam.REDIRECT_URIS.toString());
            for (int i = 0; i < redirectUrisJsonArray.length(); ++i) {
                String redirectionUri = redirectUrisJsonArray.getString(i);
                redirectUris.add(redirectionUri);
            }
        }
        ArrayList<String> claimRedirectUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString())) {
            JSONArray jsonArray = requestObject.getJSONArray(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString());
            for (int i = 0; i < jsonArray.length(); ++i) {
                String uri = jsonArray.getString(i);
                claimRedirectUris.add(uri);
            }
        }
        HashSet<String> responseTypes = new HashSet<String>();
        if (requestObject.has(RegisterRequestParam.RESPONSE_TYPES.toString())) {
            JSONArray responseTypesJsonArray = requestObject.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString());
            for (int i = 0; i < responseTypesJsonArray.length(); ++i) {
                responseTypes.add(responseTypesJsonArray.getString(i));
            }
        }
        HashSet<GrantType> grantTypes = new HashSet<GrantType>();
        if (requestObject.has(RegisterRequestParam.GRANT_TYPES.toString())) {
            JSONArray grantTypesJsonArray = requestObject.getJSONArray(RegisterRequestParam.GRANT_TYPES.toString());
            for (int i = 0; i < grantTypesJsonArray.length(); ++i) {
                GrantType gt = GrantType.fromString((String)grantTypesJsonArray.getString(i));
                if (gt == null) continue;
                grantTypes.add(gt);
            }
        }
        ArrayList<String> contacts = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.CONTACTS.toString())) {
            JSONArray contactsJsonArray = requestObject.getJSONArray(RegisterRequestParam.CONTACTS.toString());
            for (int i = 0; i < contactsJsonArray.length(); ++i) {
                contacts.add(contactsJsonArray.getString(i));
            }
        }
        ArrayList<String> defaultAcrValues = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.DEFAULT_ACR_VALUES.toString())) {
            JSONArray defaultAcrValuesJsonArray = requestObject.getJSONArray(RegisterRequestParam.DEFAULT_ACR_VALUES.toString());
            for (int i = 0; i < defaultAcrValuesJsonArray.length(); ++i) {
                defaultAcrValues.add(defaultAcrValuesJsonArray.getString(i));
            }
        }
        ArrayList<String> postLogoutRedirectUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString())) {
            JSONArray postLogoutRedirectUrisJsonArray = requestObject.getJSONArray(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString());
            for (int i = 0; i < postLogoutRedirectUrisJsonArray.length(); ++i) {
                postLogoutRedirectUris.add(postLogoutRedirectUrisJsonArray.getString(i));
            }
        }
        ArrayList<String> requestUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.REQUEST_URIS.toString())) {
            JSONArray requestUrisJsonArray = requestObject.getJSONArray(RegisterRequestParam.REQUEST_URIS.toString());
            for (int i = 0; i < requestUrisJsonArray.length(); ++i) {
                requestUris.add(requestUrisJsonArray.getString(i));
            }
        }
        ArrayList<String> authorizedOrigins = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.AUTHORIZED_ORIGINS.toString())) {
            JSONArray authorizedOriginsJsonArray = requestObject.getJSONArray(RegisterRequestParam.AUTHORIZED_ORIGINS.toString());
            for (int i = 0; i < authorizedOriginsJsonArray.length(); ++i) {
                authorizedOrigins.add(authorizedOriginsJsonArray.getString(i));
            }
        }
        ArrayList<String> scope = new ArrayList<String>();
        if (authorizationRequestCustomAllowedParameters && requestObject.has(RegisterRequestParam.SCOPES.toString())) {
            JSONArray scopesJsonArray = requestObject.getJSONArray(RegisterRequestParam.SCOPES.toString());
            for (int i = 0; i < scopesJsonArray.length(); ++i) {
                scope.add(scopesJsonArray.getString(i));
            }
        } else if (requestObject.has(RegisterRequestParam.SCOPE.toString())) {
            String[] scopeArray;
            String scopeString = requestObject.getString(RegisterRequestParam.SCOPE.toString());
            for (String s : scopeArray = scopeString.split(" ")) {
                if (!org.apache.commons.lang.StringUtils.isNotBlank((String)s)) continue;
                scope.add(s);
            }
        }
        ArrayList<String> claims = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.CLAIMS.toString())) {
            String[] claimsArray;
            String claimsString = requestObject.getString(RegisterRequestParam.CLAIMS.toString());
            for (String c : claimsArray = claimsString.split(" ")) {
                if (!org.apache.commons.lang.StringUtils.isNotBlank((String)c)) continue;
                claims.add(c);
            }
        }
        RegisterRequest result = new RegisterRequest();
        JsonApplier.getInstance().apply(requestObject, (Object)result);
        result.setJsonObject(requestObject);
        result.setRequestUris(requestUris);
        result.setAuthorizedOrigins(authorizedOrigins);
        result.setClaimsRedirectUris(claimRedirectUris);
        result.setInitiateLoginUri(requestObject.optString(RegisterRequestParam.INITIATE_LOGIN_URI.toString()));
        result.setPostLogoutRedirectUris(postLogoutRedirectUris);
        result.setDefaultAcrValues(defaultAcrValues);
        result.setRequireAuthTime(requestObject.has(RegisterRequestParam.REQUIRE_AUTH_TIME.toString()) && requestObject.getBoolean(RegisterRequestParam.REQUIRE_AUTH_TIME.toString()));
        result.setFrontChannelLogoutUri(requestObject.optString(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString()));
        result.setFrontChannelLogoutSessionRequired(requestObject.optBoolean(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString()));
        result.setBackchannelLogoutUris(RegisterRequest.extractList(requestObject, RegisterRequestParam.BACKCHANNEL_LOGOUT_URI.toString()));
        result.setBackchannelLogoutSessionRequired(requestObject.optBoolean(RegisterRequestParam.BACKCHANNEL_LOGOUT_SESSION_REQUIRED.toString()));
        result.setAccessTokenLifetime(requestObject.has(RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString()) ? Integer.valueOf(requestObject.getInt(RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString())) : null);
        result.setDefaultMaxAge(requestObject.has(RegisterRequestParam.DEFAULT_MAX_AGE.toString()) ? Integer.valueOf(requestObject.getInt(RegisterRequestParam.DEFAULT_MAX_AGE.toString())) : null);
        result.setTlsClientAuthSubjectDn(requestObject.optString(RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString()));
        result.setAllowSpontaneousScopes(requestObject.optBoolean(RegisterRequestParam.ALLOW_SPONTANEOUS_SCOPES.toString()));
        result.setSpontaneousScopes(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.SPONTANEOUS_SCOPES.toString()));
        result.setRunIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims(requestObject.optBoolean(RegisterRequestParam.RUN_INTROSPECTION_SCRIPT_BEFORE_ACCESS_TOKEN_CREATION_AS_JWT_AND_INCLUDE_CLAIMS.toString()));
        result.setKeepClientAuthorizationAfterExpiration(requestObject.optBoolean(RegisterRequestParam.KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION.toString()));
        result.setRptAsJwt(requestObject.optBoolean(RegisterRequestParam.RPT_AS_JWT.toString()));
        result.setAccessTokenAsJwt(requestObject.optBoolean(RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString()));
        result.setAccessTokenSigningAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString())));
        result.setIdTokenSignedResponseAlg(requestObject.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()) ? SignatureAlgorithm.fromString((String)requestObject.getString(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString())) : null);
        result.setIdTokenEncryptedResponseAlg(requestObject.has(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString()) ? KeyEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString())) : null);
        result.setIdTokenEncryptedResponseEnc(requestObject.has(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString()) ? BlockEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString())) : null);
        result.setUserInfoSignedResponseAlg(requestObject.has(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString()) ? SignatureAlgorithm.fromString((String)requestObject.getString(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString())) : null);
        result.setUserInfoEncryptedResponseAlg(requestObject.has(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString()) ? KeyEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString())) : null);
        result.setUserInfoEncryptedResponseEnc(requestObject.has(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString()) ? BlockEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString())) : null);
        result.setRequestObjectSigningAlg(requestObject.has(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()) ? SignatureAlgorithm.fromString((String)requestObject.getString(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString())) : null);
        result.setRequestObjectEncryptionAlg(requestObject.has(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString()) ? KeyEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString())) : null);
        result.setRequestObjectEncryptionEnc(requestObject.has(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString()) ? BlockEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString())) : null);
        result.setTokenEndpointAuthMethod(requestObject.has(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()) ? AuthenticationMethod.fromString((String)requestObject.getString(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())) : null);
        result.setTokenEndpointAuthSigningAlg(requestObject.has(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString()) ? SignatureAlgorithm.fromString((String)requestObject.getString(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())) : null);
        result.setRedirectUris(redirectUris);
        result.setScopes(scope);
        result.setScope(scope);
        result.setClaims(claims);
        result.setResponseTypes_(new ArrayList<String>(responseTypes));
        result.setGrantTypes(new ArrayList<GrantType>(grantTypes));
        result.setApplicationType(requestObject.has(RegisterRequestParam.APPLICATION_TYPE.toString()) ? ApplicationType.fromString((String)requestObject.getString(RegisterRequestParam.APPLICATION_TYPE.toString())) : ApplicationType.WEB);
        result.setContacts(contacts);
        result.setClientName(requestObject.optString(RegisterRequestParam.CLIENT_NAME.toString()));
        result.setIdTokenTokenBindingCnf(requestObject.optString(RegisterRequestParam.ID_TOKEN_TOKEN_BINDING_CNF.toString(), ""));
        result.setLogoUri(requestObject.optString(RegisterRequestParam.LOGO_URI.toString()));
        result.setClientUri(requestObject.optString(RegisterRequestParam.CLIENT_URI.toString()));
        result.setPolicyUri(requestObject.optString(RegisterRequestParam.POLICY_URI.toString()));
        result.setTosUri(requestObject.optString(RegisterRequestParam.TOS_URI.toString()));
        result.setJwksUri(requestObject.optString(RegisterRequestParam.JWKS_URI.toString()));
        result.setJwks(requestObject.optString(RegisterRequestParam.JWKS.toString()));
        result.setSectorIdentifierUri(requestObject.optString(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString()));
        result.setSubjectType(requestObject.has(RegisterRequestParam.SUBJECT_TYPE.toString()) ? SubjectType.fromString((String)requestObject.getString(RegisterRequestParam.SUBJECT_TYPE.toString())) : null);
        result.setSoftwareId(requestObject.optString(RegisterRequestParam.SOFTWARE_ID.toString()));
        result.setSoftwareVersion(requestObject.optString(RegisterRequestParam.SOFTWARE_VERSION.toString()));
        result.setSoftwareStatement(requestObject.optString(RegisterRequestParam.SOFTWARE_STATEMENT.toString()));
        result.setBackchannelTokenDeliveryMode(requestObject.has(RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString()) ? BackchannelTokenDeliveryMode.fromString((String)requestObject.getString(RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString())) : null);
        result.setBackchannelClientNotificationEndpoint(requestObject.optString(RegisterRequestParam.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.toString()));
        result.setBackchannelAuthenticationRequestSigningAlg(requestObject.has(RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString()) ? AsymmetricSignatureAlgorithm.fromString((String)requestObject.getString(RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString())) : null);
        result.setBackchannelUserCodeParameter(requestObject.has(RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString()) ? Boolean.valueOf(requestObject.getBoolean(RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString())) : null);
        return result;
    }

    private static List<String> extractList(JSONObject requestObject, String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (requestObject.has(key)) {
            try {
                JSONArray jsonArray = requestObject.getJSONArray(key);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    result.add(jsonArray.getString(i));
                }
            }
            catch (JSONException e) {
                result.add(requestObject.optString(key));
            }
        }
        return result;
    }

    @Override
    public JSONObject getJSONParameters() throws JSONException {
        JSONObject parameters = new JSONObject();
        JsonApplier.getInstance().apply((Object)this, parameters);
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REDIRECT_URIS.toString(), (Object)StringUtils.toJSONArray(this.redirectUris));
        }
        if (this.claimsRedirectUris != null && !this.claimsRedirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString(), (Object)StringUtils.toJSONArray(this.claimsRedirectUris));
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.RESPONSE_TYPES.toString(), (Object)StringUtils.toJSONArray(this.responseTypes));
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.GRANT_TYPES.toString(), (Object)StringUtils.toJSONArray(this.grantTypes));
        }
        if (this.applicationType != null) {
            parameters.put(RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            parameters.put(RegisterRequestParam.CONTACTS.toString(), (Object)StringUtils.toJSONArray(this.contacts));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientName)) {
            parameters.put(RegisterRequestParam.CLIENT_NAME.toString(), (Object)this.clientName);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.idTokenTokenBindingCnf)) {
            parameters.put(RegisterRequestParam.ID_TOKEN_TOKEN_BINDING_CNF.toString(), (Object)this.idTokenTokenBindingCnf);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tlsClientAuthSubjectDn)) {
            parameters.put(RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString(), (Object)this.tlsClientAuthSubjectDn);
        }
        if (this.allowSpontaneousScopes != null) {
            parameters.put(RegisterRequestParam.ALLOW_SPONTANEOUS_SCOPES.toString(), (Object)this.allowSpontaneousScopes);
        }
        if (this.spontaneousScopes != null && !this.spontaneousScopes.isEmpty()) {
            parameters.put(RegisterRequestParam.SPONTANEOUS_SCOPES.toString(), (Object)StringUtils.toJSONArray(this.spontaneousScopes));
        }
        if (this.runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims != null) {
            parameters.put(RegisterRequestParam.RUN_INTROSPECTION_SCRIPT_BEFORE_ACCESS_TOKEN_CREATION_AS_JWT_AND_INCLUDE_CLAIMS.toString(), (Object)this.runIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims);
        }
        if (this.keepClientAuthorizationAfterExpiration != null) {
            parameters.put(RegisterRequestParam.KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION.toString(), (Object)this.keepClientAuthorizationAfterExpiration);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.logoUri)) {
            parameters.put(RegisterRequestParam.LOGO_URI.toString(), (Object)this.logoUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientUri)) {
            parameters.put(RegisterRequestParam.CLIENT_URI.toString(), (Object)this.clientUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.policyUri)) {
            parameters.put(RegisterRequestParam.POLICY_URI.toString(), (Object)this.policyUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tosUri)) {
            parameters.put(RegisterRequestParam.TOS_URI.toString(), (Object)this.tosUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwksUri)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), (Object)this.jwksUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwks)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), (Object)this.jwks);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.sectorIdentifierUri)) {
            parameters.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            parameters.put(RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)this.subjectType.toString());
        }
        if (this.rptAsJwt != null) {
            parameters.put(RegisterRequestParam.RPT_AS_JWT.toString(), (Object)this.rptAsJwt.toString());
        }
        if (this.accessTokenAsJwt != null) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString(), (Object)this.accessTokenAsJwt.toString());
        }
        if (this.accessTokenSigningAlg != null) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString(), (Object)this.accessTokenSigningAlg.toString());
        }
        if (this.idTokenSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.requestObjectSigningAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)this.requestObjectSigningAlg.getName());
        }
        if (this.requestObjectEncryptionAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), (Object)this.requestObjectEncryptionAlg.getName());
        }
        if (this.requestObjectEncryptionEnc != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), (Object)this.requestObjectEncryptionEnc.getName());
        }
        if (this.tokenEndpointAuthMethod != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)this.tokenEndpointAuthMethod.toString());
        }
        if (this.tokenEndpointAuthSigningAlg != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), (Object)this.tokenEndpointAuthSigningAlg.toString());
        }
        if (this.defaultMaxAge != null) {
            parameters.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)this.defaultMaxAge.toString());
        }
        if (this.requireAuthTime != null) {
            parameters.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)this.requireAuthTime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            parameters.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), (Object)StringUtils.toJSONArray(this.defaultAcrValues));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.initiateLoginUri)) {
            parameters.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)this.initiateLoginUri);
        }
        if (this.postLogoutRedirectUris != null && !this.postLogoutRedirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), (Object)StringUtils.toJSONArray(this.postLogoutRedirectUris));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.frontChannelLogoutUri)) {
            parameters.put(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString(), (Object)this.frontChannelLogoutUri);
        }
        if (this.frontChannelLogoutSessionRequired != null) {
            parameters.put(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString(), (Object)this.frontChannelLogoutSessionRequired.toString());
        }
        if (this.backchannelLogoutUris != null && !this.backchannelLogoutUris.isEmpty()) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_LOGOUT_URI.toString(), (Object)StringUtils.toJSONArray(this.backchannelLogoutUris));
        }
        if (this.backchannelLogoutSessionRequired != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_LOGOUT_SESSION_REQUIRED.toString(), (Object)this.backchannelLogoutSessionRequired.toString());
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REQUEST_URIS.toString(), (Object)StringUtils.toJSONArray(this.requestUris));
        }
        if (this.authorizedOrigins != null && !this.authorizedOrigins.isEmpty()) {
            parameters.put(RegisterRequestParam.AUTHORIZED_ORIGINS.toString(), (Object)StringUtils.toJSONArray(this.authorizedOrigins));
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            parameters.put(RegisterRequestParam.SCOPES.toString(), (Object)StringUtils.toJSONArray(this.scopes));
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            parameters.put(RegisterRequestParam.SCOPE.toString(), (Object)StringUtils.implode(this.scope, (String)" "));
        }
        if (this.claims != null && !this.claims.isEmpty()) {
            parameters.put(RegisterRequestParam.CLAIMS.toString(), (Object)StringUtils.implode(this.claims, (String)" "));
        }
        if (this.accessTokenLifetime != null) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString(), (Object)this.accessTokenLifetime);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.softwareId)) {
            parameters.put(RegisterRequestParam.SOFTWARE_ID.toString(), (Object)this.softwareId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.softwareVersion)) {
            parameters.put(RegisterRequestParam.SOFTWARE_VERSION.toString(), (Object)this.softwareVersion);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.softwareStatement)) {
            parameters.put(RegisterRequestParam.SOFTWARE_STATEMENT.toString(), (Object)this.softwareStatement);
        }
        if (this.backchannelTokenDeliveryMode != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString(), (Object)this.backchannelTokenDeliveryMode);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.backchannelClientNotificationEndpoint)) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.toString(), (Object)this.backchannelClientNotificationEndpoint);
        }
        if (this.backchannelAuthenticationRequestSigningAlg != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString(), (Object)this.backchannelAuthenticationRequestSigningAlg.toString());
        }
        if (this.backchannelUserCodeParameter != null) {
            parameters.put(RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString(), (Object)this.backchannelUserCodeParameter);
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang.StringUtils.isNotBlank((String)value)) continue;
                parameters.put(name, (Object)value);
            }
        }
        return parameters;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject p_jsonObject) {
        this.jsonObject = p_jsonObject;
    }

    @Override
    public String getQueryString() {
        try {
            return ClientUtil.toPrettyJson(this.getJSONParameters()).replace("\\/", "/");
        }
        catch (JsonProcessingException | JSONException e) {
            log.error((Object)e.getMessage(), e);
            return null;
        }
    }
}

