/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.OpenIdConfigurationRequest;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.as.model.util.Util;
import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenIdConfigurationClient
extends BaseClient<OpenIdConfigurationRequest, OpenIdConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConfigurationClient.class);
    private static final String mediaTypes = String.join((CharSequence)",", "text/plain", "application/json");

    public OpenIdConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConfigurationResponse execOpenIdConfiguration() throws IOException {
        this.initClientRequest();
        return this._execOpenIdConfiguration();
    }

    @Deprecated
    public OpenIdConfigurationResponse execOpenIdConfiguration(ClientExecutor executor) throws IOException {
        this.clientRequest = new ClientRequest(this.getUrl(), executor);
        return this._execOpenIdConfiguration();
    }

    private OpenIdConfigurationResponse _execOpenIdConfiguration() throws IOException {
        this.setRequest(new OpenIdConfigurationRequest());
        this.clientRequest.accept(mediaTypes);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        this.clientRequest.followRedirects(true);
        String entity = null;
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new OpenIdConfigurationResponse(status));
            entity = (String)this.clientResponse.getEntity(String.class);
            ((OpenIdConfigurationResponse)this.getResponse()).setEntity(entity);
            ((OpenIdConfigurationResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            OpenIdConfigurationClient.parse(entity, (OpenIdConfigurationResponse)this.getResponse());
        }
        catch (JSONException e) {
            LOG.error((Object)"There is an error in the JSON response. Check if there is a syntax error in the JSON response or there is a wrong key", (Throwable)e);
            if (entity != null) {
                LOG.error((Object)("Invalid JSON: " + entity));
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (OpenIdConfigurationResponse)this.getResponse();
    }

    public static void parse(String json, OpenIdConfigurationResponse response) {
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        JSONObject jsonObj = new JSONObject(json);
        if (jsonObj.has("issuer")) {
            response.setIssuer(jsonObj.getString("issuer"));
        }
        if (jsonObj.has("authorization_endpoint")) {
            response.setAuthorizationEndpoint(jsonObj.getString("authorization_endpoint"));
        }
        if (jsonObj.has("token_endpoint")) {
            response.setTokenEndpoint(jsonObj.getString("token_endpoint"));
        }
        if (jsonObj.has("token_revocation_endpoint")) {
            response.setRevocationEndpoint(jsonObj.getString("token_revocation_endpoint"));
        }
        if (jsonObj.has("revocation_endpoint")) {
            response.setRevocationEndpoint(jsonObj.getString("revocation_endpoint"));
        }
        if (jsonObj.has("session_revocation_endpoint")) {
            response.setSessionRevocationEndpoint(jsonObj.getString("session_revocation_endpoint"));
        }
        if (jsonObj.has("userinfo_endpoint")) {
            response.setUserInfoEndpoint(jsonObj.getString("userinfo_endpoint"));
        }
        if (jsonObj.has("clientinfo_endpoint")) {
            response.setClientInfoEndpoint(jsonObj.getString("clientinfo_endpoint"));
        }
        if (jsonObj.has("check_session_iframe")) {
            response.setCheckSessionIFrame(jsonObj.getString("check_session_iframe"));
        }
        if (jsonObj.has("end_session_endpoint")) {
            response.setEndSessionEndpoint(jsonObj.getString("end_session_endpoint"));
        }
        if (jsonObj.has("jwks_uri")) {
            response.setJwksUri(jsonObj.getString("jwks_uri"));
        }
        if (jsonObj.has("registration_endpoint")) {
            response.setRegistrationEndpoint(jsonObj.getString("registration_endpoint"));
        }
        if (jsonObj.has("id_generation_endpoint")) {
            response.setIdGenerationEndpoint(jsonObj.getString("id_generation_endpoint"));
        }
        if (jsonObj.has("introspection_endpoint")) {
            response.setIntrospectionEndpoint(jsonObj.getString("introspection_endpoint"));
        }
        if (jsonObj.has("device_authorization_endpoint")) {
            response.setDeviceAuthzEndpoint(jsonObj.getString("device_authorization_endpoint"));
        }
        if (jsonObj.has("scope_to_claims_mapping")) {
            response.setScopeToClaimsMapping(OpenIdConfigurationResponse.parseScopeToClaimsMapping(jsonObj.getJSONArray("scope_to_claims_mapping")));
        }
        Util.addToListIfHas(response.getScopesSupported(), (JSONObject)jsonObj, (String)"scopes_supported");
        Util.addToListIfHas(response.getResponseTypesSupported(), (JSONObject)jsonObj, (String)"response_types_supported");
        Util.addToListIfHas(response.getResponseModesSupported(), (JSONObject)jsonObj, (String)"response_modes_supported");
        Util.addToListIfHas(response.getGrantTypesSupported(), (JSONObject)jsonObj, (String)"grant_types_supported");
        Util.addToListIfHas(response.getAcrValuesSupported(), (JSONObject)jsonObj, (String)"acr_values_supported");
        Util.addToListIfHas(response.getSubjectTypesSupported(), (JSONObject)jsonObj, (String)"subject_types_supported");
        Util.addToListIfHas(response.getUserInfoSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_signing_alg_values_supported");
        Util.addToListIfHas(response.getUserInfoEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_alg_values_supported");
        Util.addToListIfHas(response.getUserInfoEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_enc_values_supported");
        Util.addToListIfHas(response.getIdTokenSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_signing_alg_values_supported");
        Util.addToListIfHas(response.getIdTokenEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_alg_values_supported");
        Util.addToListIfHas(response.getIdTokenEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_enc_values_supported");
        Util.addToListIfHas(response.getRequestObjectSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_signing_alg_values_supported");
        Util.addToListIfHas(response.getRequestObjectEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_alg_values_supported");
        Util.addToListIfHas(response.getRequestObjectEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_enc_values_supported");
        Util.addToListIfHas(response.getTokenEndpointAuthMethodsSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_methods_supported");
        Util.addToListIfHas(response.getTokenEndpointAuthSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_signing_alg_values_supported");
        Util.addToListIfHas(response.getDisplayValuesSupported(), (JSONObject)jsonObj, (String)"display_values_supported");
        Util.addToListIfHas(response.getClaimTypesSupported(), (JSONObject)jsonObj, (String)"claim_types_supported");
        Util.addToListIfHas(response.getClaimsSupported(), (JSONObject)jsonObj, (String)"claims_supported");
        if (jsonObj.has("service_documentation")) {
            response.setServiceDocumentation(jsonObj.getString("service_documentation"));
        }
        Util.addToListIfHas(response.getClaimsLocalesSupported(), (JSONObject)jsonObj, (String)"claims_locales_supported");
        Util.addToListIfHas(response.getUiLocalesSupported(), (JSONObject)jsonObj, (String)"ui_locales_supported");
        if (jsonObj.has("claims_parameter_supported")) {
            response.setClaimsParameterSupported(jsonObj.getBoolean("claims_parameter_supported"));
        }
        if (jsonObj.has("request_parameter_supported")) {
            response.setRequestParameterSupported(jsonObj.getBoolean("request_parameter_supported"));
        }
        if (jsonObj.has("request_uri_parameter_supported")) {
            response.setRequestUriParameterSupported(jsonObj.getBoolean("request_uri_parameter_supported"));
        }
        if (jsonObj.has("tls_client_certificate_bound_access_tokens")) {
            response.setTlsClientCertificateBoundAccessTokens(jsonObj.optBoolean("tls_client_certificate_bound_access_tokens"));
        }
        if (jsonObj.has("frontchannel_logout_supported")) {
            response.setFrontChannelLogoutSupported(jsonObj.getBoolean("frontchannel_logout_supported"));
        }
        if (jsonObj.has("frontchannel_logout_session_supported")) {
            response.setFrontChannelLogoutSessionSupported(jsonObj.getBoolean("frontchannel_logout_session_supported"));
        }
        if (jsonObj.has("backchannel_logout_supported")) {
            response.setBackchannelLogoutSupported(jsonObj.optBoolean("backchannel_logout_supported"));
        }
        if (jsonObj.has("backchannel_logout_session_supported")) {
            response.setBackchannelLogoutSessionSupported(jsonObj.optBoolean("backchannel_logout_session_supported"));
        }
        if (jsonObj.has("require_request_uri_registration")) {
            response.setRequireRequestUriRegistration(jsonObj.getBoolean("require_request_uri_registration"));
        }
        if (jsonObj.has("op_policy_uri")) {
            response.setOpPolicyUri(jsonObj.getString("op_policy_uri"));
        }
        if (jsonObj.has("op_tos_uri")) {
            response.setOpTosUri(jsonObj.getString("op_tos_uri"));
        }
        if (jsonObj.has("backchannel_authentication_endpoint")) {
            response.setBackchannelAuthenticationEndpoint(jsonObj.getString("backchannel_authentication_endpoint"));
        }
        Util.addToListIfHas(response.getBackchannelTokenDeliveryModesSupported(), (JSONObject)jsonObj, (String)"backchannel_token_delivery_modes_supported");
        Util.addToListIfHas(response.getBackchannelAuthenticationRequestSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"backchannel_authentication_request_signing_alg_values_supported");
        if (jsonObj.has("backchannel_user_code_parameter_supported")) {
            response.setBackchannelUserCodeParameterSupported(jsonObj.getBoolean("backchannel_user_code_parameter_supported"));
        }
    }

    public static OpenIdConfigurationResponse parse(String json) {
        OpenIdConfigurationResponse response = new OpenIdConfigurationResponse();
        OpenIdConfigurationClient.parse(json, response);
        return response;
    }
}

