/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.GluuConfigurationRequest;
import io.jans.as.client.GluuConfigurationResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class GluuConfigurationClient
extends BaseClient<GluuConfigurationRequest, GluuConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(GluuConfigurationClient.class);

    public GluuConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public GluuConfigurationResponse execGluuConfiguration() {
        this.initClientRequest();
        this.setRequest(new GluuConfigurationRequest());
        this.clientRequest.header("Content-Type", (Object)"application/json");
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            this.setResponse(new GluuConfigurationResponse());
            String entity = (String)this.clientResponse.getEntity(String.class);
            ((GluuConfigurationResponse)this.getResponse()).setEntity(entity);
            ((GluuConfigurationResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            ((GluuConfigurationResponse)this.getResponse()).setStatus(this.clientResponse.getStatus());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("id_generation_endpoint")) {
                    ((GluuConfigurationResponse)this.getResponse()).setIdGenerationEndpoint(jsonObj.getString("id_generation_endpoint"));
                }
                if (jsonObj.has("introspection_endpoint")) {
                    ((GluuConfigurationResponse)this.getResponse()).setIntrospectionEndpoint(jsonObj.getString("introspection_endpoint"));
                }
                if (jsonObj.has("auth_level_mapping")) {
                    ((GluuConfigurationResponse)this.getResponse()).setAuthLevelMapping(this.mapJsonToAuthLevelMapping(jsonObj.getJSONObject("auth_level_mapping")));
                }
                if (jsonObj.has("scope_to_claims_mapping")) {
                    ((GluuConfigurationResponse)this.getResponse()).setScopeToClaimsMapping(this.mapJsonToScopeToClaimsMapping(jsonObj.getJSONObject("scope_to_claims_mapping")));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (GluuConfigurationResponse)this.getResponse();
    }

    private Map<Integer, Set<String>> mapJsonToAuthLevelMapping(JSONObject jsonObject) {
        HashMap<Integer, Set<String>> authLevelMapping = new HashMap<Integer, Set<String>>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            try {
                String key = (String)keys.next();
                Integer level = new Integer(key);
                authLevelMapping.put(level, new HashSet());
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    ((Set)authLevelMapping.get(level)).add(jsonArray.getString(i));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return authLevelMapping;
    }

    private Map<String, Set<String>> mapJsonToScopeToClaimsMapping(JSONObject jsonObject) {
        HashMap<String, Set<String>> scopeToClaimsMapping = new HashMap<String, Set<String>>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            try {
                String scope = (String)keys.next();
                scopeToClaimsMapping.put(scope, new HashSet());
                JSONArray jsonArray = jsonObject.getJSONArray(scope);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    ((Set)scopeToClaimsMapping.get(scope)).add(jsonArray.getString(i));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return scopeToClaimsMapping;
    }
}

