/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.DeviceAuthzRequest;
import io.jans.as.client.DeviceAuthzResponse;
import io.jans.as.model.util.Util;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.json.JSONObject;

public class DeviceAuthzClient
extends BaseClient<DeviceAuthzRequest, DeviceAuthzResponse> {
    private static final Logger LOG = Logger.getLogger(DeviceAuthzClient.class);

    public DeviceAuthzClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public DeviceAuthzResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public DeviceAuthzResponse exec(ClientExecutor clientExecutor) {
        this.clientRequest = new ClientRequest(this.getUrl(), clientExecutor);
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceAuthzResponse _exec() {
        try {
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            this.clientRequest.header("Content-Type", (Object)((DeviceAuthzRequest)this.request).getContentType());
            new ClientAuthnEnabler(this.clientRequest).exec((ClientAuthnRequest)this.getRequest());
            String scopesAsString = Util.listAsString(((DeviceAuthzRequest)this.getRequest()).getScopes());
            if (StringUtils.isNotBlank((String)scopesAsString)) {
                this.clientRequest.formParameter("scope", (Object)scopesAsString);
            }
            if (StringUtils.isNotBlank((String)((DeviceAuthzRequest)this.getRequest()).getClientId())) {
                this.clientRequest.formParameter("client_id", (Object)((DeviceAuthzRequest)this.getRequest()).getClientId());
            }
            this.clientResponse = this.clientRequest.post(String.class);
            this.setResponse(new DeviceAuthzResponse((ClientResponse<String>)this.clientResponse));
            String entity = (String)this.clientResponse.getEntity(String.class);
            ((DeviceAuthzResponse)this.getResponse()).setEntity(entity);
            ((DeviceAuthzResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("user_code")) {
                    ((DeviceAuthzResponse)this.getResponse()).setUserCode(jsonObj.getString("user_code"));
                }
                if (jsonObj.has("device_code")) {
                    ((DeviceAuthzResponse)this.getResponse()).setDeviceCode(jsonObj.getString("device_code"));
                }
                if (jsonObj.has("interval")) {
                    ((DeviceAuthzResponse)this.getResponse()).setInterval(jsonObj.getInt("interval"));
                }
                if (jsonObj.has("verification_uri")) {
                    ((DeviceAuthzResponse)this.getResponse()).setVerificationUri(jsonObj.getString("verification_uri"));
                }
                if (jsonObj.has("verification_uri_complete")) {
                    ((DeviceAuthzResponse)this.getResponse()).setVerificationUriComplete(jsonObj.getString("verification_uri_complete"));
                }
                if (jsonObj.has("expires_in")) {
                    ((DeviceAuthzResponse)this.getResponse()).setExpiresIn(jsonObj.getInt("expires_in"));
                }
            }
            DeviceAuthzResponse deviceAuthzResponse = (DeviceAuthzResponse)this.getResponse();
            return deviceAuthzResponse;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            DeviceAuthzResponse deviceAuthzResponse = null;
            return deviceAuthzResponse;
        }
        finally {
            this.closeConnection();
        }
    }
}

