/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.token.ClientAssertionType;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientRequest;

public class ClientAuthnEnabler {
    private static final Logger LOG = Logger.getLogger(ClientAuthnEnabler.class);
    private ClientRequest clientRequest;

    public ClientAuthnEnabler(ClientRequest clientRequest) {
        this.clientRequest = clientRequest;
    }

    public void exec(ClientAuthnRequest request) {
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && request.hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + request.getEncodedCredentials()));
            return;
        }
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (request.getAuthUsername() != null && !request.getAuthUsername().isEmpty()) {
                this.clientRequest.formParameter("client_id", (Object)request.getAuthUsername());
            }
            if (request.getAuthPassword() != null && !request.getAuthPassword().isEmpty()) {
                this.clientRequest.formParameter("client_secret", (Object)request.getAuthPassword());
            }
            return;
        }
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || request.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            this.clientRequest.formParameter("client_assertion_type", (Object)ClientAssertionType.JWT_BEARER);
            if (request.getClientAssertion() != null) {
                this.clientRequest.formParameter("client_assertion", (Object)request.getClientAssertion());
            }
            if (request.getAuthUsername() != null && !request.getAuthUsername().isEmpty()) {
                this.clientRequest.formParameter("client_id", (Object)request.getAuthUsername());
            }
        }
    }
}

