/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.AuthorizationRequest;
import io.jans.as.client.BaseRequest;
import io.jans.as.client.BaseResponse;
import io.jans.as.client.RegisterRequest;
import io.jans.as.client.UserInfoRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.AuthorizationMethod;
import io.jans.as.model.common.HasParamName;
import io.jans.as.model.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;

public abstract class BaseClient<T extends BaseRequest, V extends BaseResponse> {
    private static final Logger LOG = Logger.getLogger(BaseClient.class);
    private String url;
    protected T request;
    protected V response;
    protected ClientRequest clientRequest = null;
    protected ClientResponse<String> clientResponse = null;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers = new HashMap<String, String>();
    protected ClientExecutor executor = null;

    public BaseClient() {
    }

    public BaseClient(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }

    public V getResponse() {
        return this.response;
    }

    public void setResponse(V response) {
        this.response = response;
    }

    public ClientExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ClientExecutor executor) {
        this.executor = executor;
    }

    protected void addReqParam(String p_key, HasParamName p_value) {
        if (p_value != null) {
            this.addReqParam(p_key, p_value.getParamName());
        }
    }

    protected void addReqParam(String p_key, String p_value) {
        if (Util.allNotBlank((String[])new String[]{p_key, p_value})) {
            if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                this.clientRequest.formParameter(p_key, (Object)p_value);
            } else {
                this.clientRequest.queryParameter(p_key, (Object)p_value);
            }
        }
    }

    public static void putAllFormParameters(ClientRequest p_clientRequest, BaseRequest p_request) {
        Map<String, String> parameters;
        if (p_clientRequest != null && p_request != null && (parameters = p_request.getParameters()) != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                p_clientRequest.formParameter(e.getKey(), (Object)e.getValue());
            }
        }
    }

    public String getRequestAsString() {
        StringBuilder sb = new StringBuilder();
        try {
            URL theUrl = new URL(this.url);
            if (this.getHttpMethod().equals("POST") || this.getHttpMethod().equals("PUT") || this.getHttpMethod().equals("DELETE")) {
                AuthorizationRequest authorizationRequest;
                sb.append(this.getHttpMethod()).append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                if (StringUtils.isNotBlank((String)((BaseRequest)this.request).getContentType())) {
                    sb.append("\n");
                    sb.append("Content-Type: ").append(((BaseRequest)this.request).getContentType());
                }
                if (StringUtils.isNotBlank((String)((BaseRequest)this.request).getMediaType())) {
                    sb.append("\n");
                    sb.append("Accept: ").append(((BaseRequest)this.request).getMediaType());
                }
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
                    sb.append("\n");
                    sb.append(AuthorizationRequest.NO_REDIRECT_HEADER + ": true");
                }
                if (((BaseRequest)this.request).getAuthorizationMethod() == null) {
                    if ((((BaseRequest)this.request).getAuthenticationMethod() == null || ((BaseRequest)this.request).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC) && ((BaseRequest)this.request).hasCredentials()) {
                        String encodedCredentials = ((BaseRequest)this.request).getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    }
                } else if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD && this.request instanceof UserInfoRequest) {
                    String accessToken = ((UserInfoRequest)this.request).getAccessToken();
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
                sb.append("\n");
                sb.append("\n");
                sb.append(((BaseRequest)this.request).getQueryString());
            } else if (this.getHttpMethod().equals("GET")) {
                AuthorizationRequest authorizationRequest;
                sb.append(this.getHttpMethod()).append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                if (StringUtils.isNotBlank((String)((BaseRequest)this.request).getQueryString())) {
                    sb.append("?").append(((BaseRequest)this.request).getQueryString());
                }
                sb.append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
                    sb.append("\n");
                    sb.append(AuthorizationRequest.NO_REDIRECT_HEADER + ": true");
                }
                if (((BaseRequest)this.request).getAuthorizationMethod() == null) {
                    if (((BaseRequest)this.request).hasCredentials()) {
                        String encodedCredentials = ((BaseRequest)this.request).getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    } else if (this.request instanceof RegisterRequest) {
                        RegisterRequest r = (RegisterRequest)this.request;
                        String registrationAccessToken = r.getRegistrationAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(registrationAccessToken);
                    }
                } else if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD && this.request instanceof UserInfoRequest) {
                    String accessToken = ((UserInfoRequest)this.request).getAccessToken();
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public String getResponseAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.response != null) {
            sb.append("HTTP/1.1 ").append(((BaseResponse)this.response).getStatus());
            if (((BaseResponse)this.response).getHeaders() != null) {
                for (String key : ((BaseResponse)this.response).getHeaders().keySet()) {
                    sb.append("\n").append(key).append(": ").append(((List)((BaseResponse)this.response).getHeaders().get((Object)key)).get(0));
                }
            }
            if (((BaseResponse)this.response).getEntity() != null) {
                sb.append("\n");
                sb.append("\n");
                sb.append(((BaseResponse)this.response).getEntity());
            }
        }
        return sb.toString();
    }

    protected void initClientRequest() {
        this.clientRequest = this.executor == null ? new ClientRequest(this.getUrl()) : new ClientRequest(this.getUrl(), this.executor);
        for (Cookie cookie : this.cookies) {
            this.clientRequest.cookie(cookie);
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            this.clientRequest.header((String)entry.getKey(), entry.getValue());
        }
    }

    public void closeConnection() {
        try {
            if (this.clientResponse != null) {
                this.clientResponse.releaseConnection();
            }
            if (this.clientRequest != null && this.clientRequest.getExecutor() != null) {
                this.clientRequest.getExecutor().close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public abstract String getHttpMethod();

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

