/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BackchannelAuthenticationRequest;
import io.jans.as.client.BackchannelAuthenticationResponse;
import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.util.Util;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientResponse;
import org.json.JSONObject;

public class BackchannelAuthenticationClient
extends BaseClient<BackchannelAuthenticationRequest, BackchannelAuthenticationResponse> {
    private static final Logger LOG = Logger.getLogger(BackchannelAuthenticationClient.class);

    public BackchannelAuthenticationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public BackchannelAuthenticationResponse exec() {
        BackchannelAuthenticationResponse response = null;
        try {
            this.initClientRequest();
            response = this.exec_();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    private BackchannelAuthenticationResponse exec_() throws Exception {
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        this.clientRequest.header("Content-Type", (Object)((BackchannelAuthenticationRequest)this.request).getContentType());
        if (((BackchannelAuthenticationRequest)this.request).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && ((BackchannelAuthenticationRequest)this.request).hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + ((BackchannelAuthenticationRequest)this.request).getEncodedCredentials()));
        }
        String scopesAsString = Util.listAsString(((BackchannelAuthenticationRequest)this.getRequest()).getScope());
        String acrValuesAsString = Util.listAsString(((BackchannelAuthenticationRequest)this.getRequest()).getAcrValues());
        if (StringUtils.isNotBlank((String)scopesAsString)) {
            this.clientRequest.formParameter("scope", (Object)scopesAsString);
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getClientNotificationToken())) {
            this.clientRequest.formParameter("client_notification_token", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getClientNotificationToken());
        }
        if (StringUtils.isNotBlank((String)acrValuesAsString)) {
            this.clientRequest.formParameter("acr_values", (Object)acrValuesAsString);
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getLoginHintToken())) {
            this.clientRequest.formParameter("login_hint_token", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getLoginHintToken());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getIdTokenHint())) {
            this.clientRequest.formParameter("id_token_hint", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getIdTokenHint());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getLoginHint())) {
            this.clientRequest.formParameter("login_hint", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getLoginHint());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getBindingMessage())) {
            this.clientRequest.formParameter("binding_message", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getBindingMessage());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getUserCode())) {
            this.clientRequest.formParameter("user_code", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getUserCode());
        }
        if (((BackchannelAuthenticationRequest)this.getRequest()).getRequestedExpiry() != null) {
            this.clientRequest.formParameter("requested_expiry", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getRequestedExpiry());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getClientId())) {
            this.clientRequest.formParameter("client_id", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getClientId());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getRequest())) {
            this.clientRequest.formParameter("request", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getRequest());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getRequestUri())) {
            this.clientRequest.formParameter("request_uri", (Object)((BackchannelAuthenticationRequest)this.getRequest()).getRequestUri());
        }
        new ClientAuthnEnabler(this.clientRequest).exec((ClientAuthnRequest)this.getRequest());
        this.clientResponse = this.clientRequest.post(String.class);
        this.setResponse(new BackchannelAuthenticationResponse((ClientResponse<String>)this.clientResponse));
        String entity = (String)this.clientResponse.getEntity(String.class);
        ((BackchannelAuthenticationResponse)this.getResponse()).setEntity(entity);
        ((BackchannelAuthenticationResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
        if (StringUtils.isNotBlank((String)entity)) {
            JSONObject jsonObj = new JSONObject(entity);
            if (jsonObj.has("auth_req_id")) {
                ((BackchannelAuthenticationResponse)this.getResponse()).setAuthReqId(jsonObj.getString("auth_req_id"));
            }
            if (jsonObj.has("expires_in")) {
                ((BackchannelAuthenticationResponse)this.getResponse()).setExpiresIn(jsonObj.getInt("expires_in"));
            }
            if (jsonObj.has("interval")) {
                ((BackchannelAuthenticationResponse)this.getResponse()).setInterval(jsonObj.getInt("interval"));
            }
        }
        return (BackchannelAuthenticationResponse)this.getResponse();
    }
}

