/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseRequest;
import io.jans.as.model.authorize.CodeVerifier;
import io.jans.as.model.common.Display;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationRequest
extends BaseRequest {
    public static String NO_REDIRECT_HEADER = "X-Gluu-NoRedirect";
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String state;
    private ResponseMode responseMode;
    private String nonce;
    private Display display;
    private List<Prompt> prompts;
    private Integer maxAge;
    private List<String> uiLocales;
    private List<String> claimsLocales;
    private String idTokenHint;
    private String loginHint;
    private List<String> acrValues;
    private JSONObject claims;
    private String registration;
    private String request;
    private String requestUri;
    private boolean requestSessionId;
    private String sessionId;
    private String accessToken;
    private boolean useNoRedirectHeader;
    private String codeChallenge;
    private String codeChallengeMethod;
    private Map<String, String> customResponseHeaders;

    public AuthorizationRequest(List<ResponseType> responseTypes, String clientId, List<String> scopes, String redirectUri, String nonce) {
        this.responseTypes = responseTypes;
        this.clientId = clientId;
        this.scopes = scopes;
        this.redirectUri = redirectUri;
        this.nonce = nonce;
        this.prompts = new ArrayList<Prompt>();
        this.useNoRedirectHeader = false;
    }

    public CodeVerifier generateAndSetCodeChallengeWithMethod() {
        CodeVerifier verifier = new CodeVerifier(CodeVerifier.CodeChallengeMethod.S256);
        this.codeChallenge = verifier.getCodeChallenge();
        this.codeChallengeMethod = verifier.getTransformationType().getPkceString();
        return verifier;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public void setPrompts(List<Prompt> prompts) {
        this.prompts = prompts;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public List<String> getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(List<String> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public List<String> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimsLocales(List<String> claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public List<String> getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(List<String> acrValues) {
        this.acrValues = acrValues;
    }

    public JSONObject getClaims() {
        return this.claims;
    }

    public void setClaims(JSONObject claims) {
        this.claims = claims;
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public boolean isRequestSessionId() {
        return this.requestSessionId;
    }

    public void setRequestSessionId(boolean p_requestSessionId) {
        this.requestSessionId = p_requestSessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isUseNoRedirectHeader() {
        return this.useNoRedirectHeader;
    }

    public void setUseNoRedirectHeader(boolean useNoRedirectHeader) {
        this.useNoRedirectHeader = useNoRedirectHeader;
    }

    public String getResponseTypesAsString() {
        return Util.asString(this.responseTypes);
    }

    public String getScopesAsString() {
        return Util.listAsString(this.scopes);
    }

    public String getPromptsAsString() {
        return Util.asString(this.prompts);
    }

    public String getUiLocalesAsString() {
        return Util.listAsString(this.uiLocales);
    }

    public String getClaimsLocalesAsString() {
        return Util.listAsString(this.claimsLocales);
    }

    public String getAcrValuesAsString() {
        return Util.listAsString(this.acrValues);
    }

    public String getCustomResponseHeadersAsString() throws JSONException {
        return Util.mapAsString(this.customResponseHeaders);
    }

    public Map<String, String> getCustomResponseHeaders() {
        return this.customResponseHeaders;
    }

    public void setCustomResponseHeaders(Map<String, String> customResponseHeaders) {
        this.customResponseHeaders = customResponseHeaders;
    }

    public String getClaimsAsString() {
        if (this.claims != null) {
            return this.claims.toString();
        }
        return null;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            String responseTypesAsString = this.getResponseTypesAsString();
            String scopesAsString = this.getScopesAsString();
            String promptsAsString = this.getPromptsAsString();
            String customResponseHeadersAsString = this.getCustomResponseHeadersAsString();
            if (StringUtils.isNotBlank((String)responseTypesAsString)) {
                queryStringBuilder.append("response_type").append("=").append(URLEncoder.encode(responseTypesAsString, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.clientId)) {
                queryStringBuilder.append("&").append("client_id").append("=").append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)scopesAsString)) {
                queryStringBuilder.append("&").append("scope").append("=").append(URLEncoder.encode(scopesAsString, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.redirectUri)) {
                queryStringBuilder.append("&").append("redirect_uri").append("=").append(URLEncoder.encode(this.redirectUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.state)) {
                queryStringBuilder.append("&").append("state").append("=").append(URLEncoder.encode(this.state, "UTF-8"));
            }
            String uiLocalesAsString = this.getUiLocalesAsString();
            String claimLocalesAsString = this.getClaimsLocalesAsString();
            String acrValuesAsString = this.getAcrValuesAsString();
            String claimsAsString = this.getClaimsAsString();
            if (this.responseMode != null) {
                queryStringBuilder.append("&").append("response_mode").append("=").append(URLEncoder.encode(this.responseMode.toString(), "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.nonce)) {
                queryStringBuilder.append("&").append("nonce").append("=").append(URLEncoder.encode(this.nonce, "UTF-8"));
            }
            if (this.display != null) {
                queryStringBuilder.append("&").append("display").append("=").append(URLEncoder.encode(this.display.toString(), "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)promptsAsString)) {
                queryStringBuilder.append("&").append("prompt").append("=").append(URLEncoder.encode(promptsAsString, "UTF-8"));
            }
            if (this.maxAge != null) {
                queryStringBuilder.append("&").append("max_age").append("=").append(this.maxAge);
            }
            if (StringUtils.isNotBlank((String)uiLocalesAsString)) {
                queryStringBuilder.append("&").append("ui_locales").append("=").append(URLEncoder.encode(uiLocalesAsString, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)claimLocalesAsString)) {
                queryStringBuilder.append("&").append("claims_locales").append("=").append(URLEncoder.encode(claimLocalesAsString, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.idTokenHint)) {
                queryStringBuilder.append("&").append("id_token_hint").append("=").append(this.idTokenHint);
            }
            if (StringUtils.isNotBlank((String)this.loginHint)) {
                queryStringBuilder.append("&").append("login_hint").append("=").append(this.loginHint);
            }
            if (StringUtils.isNotBlank((String)acrValuesAsString)) {
                queryStringBuilder.append("&").append("acr_values").append("=").append(URLEncoder.encode(acrValuesAsString, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)claimsAsString)) {
                queryStringBuilder.append("&").append("claims").append("=").append(URLEncoder.encode(claimsAsString, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.registration)) {
                queryStringBuilder.append("&").append("registration").append("=").append(this.registration);
            }
            if (StringUtils.isNotBlank((String)this.request)) {
                queryStringBuilder.append("&").append("request").append("=").append(URLEncoder.encode(this.request, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.requestUri)) {
                queryStringBuilder.append("&").append("request_uri").append("=").append(URLEncoder.encode(this.requestUri, "UTF-8"));
            }
            if (this.requestSessionId) {
                queryStringBuilder.append("&").append("request_session_id").append("=").append(URLEncoder.encode(Boolean.toString(this.requestSessionId), "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.sessionId)) {
                queryStringBuilder.append("&").append("session_id").append("=").append(URLEncoder.encode(this.sessionId, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.accessToken)) {
                queryStringBuilder.append("&").append("access_token").append("=").append(URLEncoder.encode(this.accessToken, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.codeChallenge)) {
                queryStringBuilder.append("&").append("code_challenge").append("=").append(this.codeChallenge);
            }
            if (StringUtils.isNotBlank((String)this.codeChallengeMethod)) {
                queryStringBuilder.append("&").append("code_challenge_method").append("=").append(this.codeChallengeMethod);
            }
            if (StringUtils.isNotBlank((String)customResponseHeadersAsString)) {
                queryStringBuilder.append("&").append("custom_response_headers").append("=").append(URLEncoder.encode(customResponseHeadersAsString, "UTF-8"));
            }
            for (String key : this.getCustomParameters().keySet()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append(key).append("=").append(this.getCustomParameters().get(key));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            String responseTypesAsString = this.getResponseTypesAsString();
            String scopesAsString = this.getScopesAsString();
            String promptsAsString = this.getPromptsAsString();
            String customResponseHeadersAsString = this.getCustomResponseHeadersAsString();
            if (StringUtils.isNotBlank((String)responseTypesAsString)) {
                parameters.put("response_type", responseTypesAsString);
            }
            if (StringUtils.isNotBlank((String)this.clientId)) {
                parameters.put("client_id", this.clientId);
            }
            if (StringUtils.isNotBlank((String)scopesAsString)) {
                parameters.put("scope", scopesAsString);
            }
            if (StringUtils.isNotBlank((String)this.redirectUri)) {
                parameters.put("redirect_uri", this.redirectUri);
            }
            if (StringUtils.isNotBlank((String)this.state)) {
                parameters.put("state", this.state);
            }
            String uiLocalesAsString = this.getUiLocalesAsString();
            String claimLocalesAsString = this.getClaimsLocalesAsString();
            String acrValuesAsString = this.getAcrValuesAsString();
            String claimsAsString = this.getClaimsAsString();
            if (this.responseMode != null) {
                parameters.put("response_mode", this.responseMode.toString());
            }
            if (StringUtils.isNotBlank((String)this.nonce)) {
                parameters.put("nonce", this.nonce);
            }
            if (this.display != null) {
                parameters.put("display", this.display.toString());
            }
            if (StringUtils.isNotBlank((String)promptsAsString)) {
                parameters.put("prompt", promptsAsString);
            }
            if (this.maxAge != null) {
                parameters.put("max_age", this.maxAge.toString());
            }
            if (StringUtils.isNotBlank((String)uiLocalesAsString)) {
                parameters.put("ui_locales", uiLocalesAsString);
            }
            if (StringUtils.isNotBlank((String)claimLocalesAsString)) {
                parameters.put("claims_locales", claimLocalesAsString);
            }
            if (StringUtils.isNotBlank((String)this.idTokenHint)) {
                parameters.put("id_token_hint", this.idTokenHint);
            }
            if (StringUtils.isNotBlank((String)this.loginHint)) {
                parameters.put("login_hint", this.loginHint);
            }
            if (StringUtils.isNotBlank((String)acrValuesAsString)) {
                parameters.put("acr_values", acrValuesAsString);
            }
            if (StringUtils.isNotBlank((String)claimsAsString)) {
                parameters.put("claims", claimsAsString);
            }
            if (StringUtils.isNotBlank((String)this.registration)) {
                parameters.put("registration", this.registration);
            }
            if (StringUtils.isNotBlank((String)this.request)) {
                parameters.put("request", this.request);
            }
            if (StringUtils.isNotBlank((String)this.requestUri)) {
                parameters.put("request_uri", this.requestUri);
            }
            if (this.requestSessionId) {
                parameters.put("request_session_id", Boolean.toString(this.requestSessionId));
            }
            if (StringUtils.isNotBlank((String)this.sessionId)) {
                parameters.put("session_id", this.sessionId);
            }
            if (StringUtils.isNotBlank((String)this.accessToken)) {
                parameters.put("access_token", this.accessToken);
            }
            if (StringUtils.isNotBlank((String)this.codeChallenge)) {
                parameters.put("code_challenge", this.codeChallenge);
            }
            if (StringUtils.isNotBlank((String)this.codeChallengeMethod)) {
                parameters.put("code_challenge_method", this.codeChallengeMethod);
            }
            if (StringUtils.isNotBlank((String)customResponseHeadersAsString)) {
                parameters.put("custom_response_headers", customResponseHeadersAsString);
            }
            for (String key : this.getCustomParameters().keySet()) {
                parameters.put(key, this.getCustomParameters().get(key));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return parameters;
    }
}

