/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.boon.messages.ResourceBundleLocator;

public class ValidationContext {
    private ArrayDeque<String> bindingPath = new ArrayDeque();
    private ResourceBundleLocator resourceBundleLocator;
    private Object parentObject;
    private Map<String, Object> params;
    private static ThreadLocal<ValidationContext> holder = new ThreadLocal();
    private String i18nMarker = "{";
    private String currentSubject;
    Map<String, Object> objectRegistry;

    public static ValidationContext getCurrentInstance() {
        return holder.get();
    }

    protected void register(ValidationContext context) {
        holder.set(context);
    }

    public Object getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(Object parentObject) {
        this.parentObject = parentObject;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Object getProposedPropertyValue(String propertyName) {
        return null;
    }

    private String calculateBindingPath() {
        StringBuilder builder = new StringBuilder(255);
        int index = 0;
        for (String component : this.bindingPath) {
            builder.append(component);
            if (++index == this.bindingPath.size()) continue;
            builder.append('.');
        }
        return builder.toString();
    }

    public void pop() {
        this.bindingPath.pop();
    }

    public void pushProperty(String component) {
        this.bindingPath.push(component);
    }

    public void pushObject(Object object) {
        String simpleName = object.getClass().getSimpleName();
        simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1, simpleName.length());
        this.bindingPath.push(simpleName);
    }

    public static String getBindingPath() {
        if (ValidationContext.getCurrentInstance() != null) {
            return ValidationContext.getCurrentInstance().calculateBindingPath();
        }
        return "";
    }

    public static ValidationContext create() {
        holder.set(new ValidationContext());
        return ValidationContext.get();
    }

    public static ValidationContext get() {
        return holder.get();
    }

    public static void destroy() {
        holder.set(null);
    }

    public Map<String, Object> getObjectRegistry() {
        return this.objectRegistry;
    }

    public void setObjectRegistry(Map<String, Object> objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    public String getMessage(String key) {
        String message = this.doGetMessageFromBundle(key);
        return message == null ? key : message;
    }

    public String getCurrentSubject() {
        return this.currentSubject;
    }

    public void setCurrentSubject(String currentSubject) {
        this.currentSubject = currentSubject;
    }

    public String createMessage(String message, String subject, Object[] actualArgs) {
        ArrayList<Object> argumentList = new ArrayList<Object>(Arrays.asList(actualArgs));
        if (subject != null) {
            argumentList.add(0, this.getMessage(subject));
        }
        try {
            return MessageFormat.format(message, argumentList.toArray());
        }
        catch (Exception ex) {
            return message;
        }
    }

    public void setResourceBundleLocator(ResourceBundleLocator resourceBundleLocator) {
        this.resourceBundleLocator = resourceBundleLocator;
    }

    protected ResourceBundleLocator getResourceBundleLocator() {
        return this.resourceBundleLocator;
    }

    private String doGetMessageFromBundle(String key) {
        if (this.resourceBundleLocator == null) {
            return null;
        }
        ResourceBundle bundle = this.resourceBundleLocator.getBundle();
        if (bundle == null) {
            return null;
        }
        String message = null;
        if (key.startsWith(this.i18nMarker)) {
            try {
                key = key.substring(1, key.length() - 1);
                message = this.lookupMessageInBundle(key, bundle, message);
            }
            catch (MissingResourceException mre) {
                message = key;
            }
        } else if (key.contains(".")) {
            try {
                message = this.lookupMessageInBundle(key, bundle, message);
            }
            catch (MissingResourceException mre) {
                message = key;
            }
        } else {
            message = key;
        }
        return message;
    }

    private String lookupMessageInBundle(String key, ResourceBundle bundle, String message) {
        if (this.getCurrentSubject() != null) {
            try {
                message = bundle.getString(key + "." + this.getCurrentSubject());
            }
            catch (MissingResourceException mre) {
                message = bundle.getString(key);
            }
        } else {
            return bundle.getString(key);
        }
        return message;
    }
}

