/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.impl;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.boon.Exceptions;
import org.boon.core.TypeType;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.MethodAccess;
import org.boon.primitive.Arry;

public class OverloadedMethod
implements MethodAccess {
    List<MethodAccess> methodAccessList = new ArrayList<MethodAccess>();
    List<List<MethodAccess>> methodAccessListByArgNumber = new ArrayList<List<MethodAccess>>();
    List<List<MethodAccess>> methodAccessListByArgNumberWithVarArg = new ArrayList<List<MethodAccess>>();
    private boolean lock;

    public OverloadedMethod() {
        for (int index = 0; index < 25; ++index) {
            this.methodAccessListByArgNumberWithVarArg.add(null);
            this.methodAccessListByArgNumber.add(null);
        }
    }

    public OverloadedMethod add(MethodAccess methodAccess) {
        if (this.lock) {
            Exceptions.die();
        }
        this.methodAccessList.add(methodAccess);
        if (!methodAccess.method().isVarArgs()) {
            List<MethodAccess> methodAccesses = this.methodAccessListByArgNumber.get(methodAccess.parameterTypes().length);
            if (methodAccesses == null) {
                methodAccesses = new ArrayList<MethodAccess>();
                this.methodAccessListByArgNumber.set(methodAccess.parameterTypes().length, methodAccesses);
            }
            methodAccesses.add(methodAccess);
        } else {
            List<MethodAccess> methodAccesses = this.methodAccessListByArgNumberWithVarArg.get(methodAccess.parameterTypes().length);
            if (methodAccesses == null) {
                methodAccesses = new ArrayList<MethodAccess>();
                this.methodAccessListByArgNumberWithVarArg.set(methodAccess.parameterTypes().length, methodAccesses);
            }
            methodAccesses.add(methodAccess);
        }
        return this;
    }

    public OverloadedMethod init() {
        if (this.lock) {
            Exceptions.die();
        }
        for (List<MethodAccess> methodAccesses : this.methodAccessListByArgNumber) {
            Collections.sort(methodAccesses);
        }
        this.lock();
        return this;
    }

    public void lock() {
        this.lock = true;
    }

    @Override
    public Object invokeDynamic(Object object, Object ... args) {
        int length = args.length;
        List<MethodAccess> methodAccesses = this.methodAccessListByArgNumber.get(length);
        int maxScore = Integer.MIN_VALUE;
        MethodAccess methodAccess = null;
        for (MethodAccess m : methodAccesses) {
            int score = 1;
            List<TypeType> paramTypeEnumList = m.paramTypeEnumList();
            if (object == null && !m.isStatic()) continue;
            block13: for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                TypeType type = paramTypeEnumList.get(argIndex);
                Object arg = args[argIndex];
                TypeType instanceType = TypeType.getInstanceType(arg);
                if (instanceType == type) {
                    score += 2000;
                    continue;
                }
                switch (type) {
                    case BYTE_WRAPPER: 
                    case BYTE: {
                        score = this.handleByteArg(score, arg, instanceType);
                        continue block13;
                    }
                    case SHORT_WRAPPER: 
                    case SHORT: {
                        score = this.handleShortArg(score, arg, instanceType);
                        continue block13;
                    }
                    case INTEGER_WRAPPER: 
                    case INT: {
                        score = this.handleIntArg(score, arg, instanceType);
                        continue block13;
                    }
                    case NULL: {
                        --score;
                        continue block13;
                    }
                    case LONG_WRAPPER: 
                    case LONG: {
                        score = this.handleLongArg(score, arg, instanceType);
                        continue block13;
                    }
                    case FLOAT_WRAPPER: 
                    case FLOAT: {
                        score = this.handleFloatArg(score, arg, instanceType);
                        continue block13;
                    }
                    case DOUBLE_WRAPPER: 
                    case DOUBLE: {
                        score = this.handleDoubleArg(score, arg, instanceType);
                        continue block13;
                    }
                    case CHAR_WRAPPER: 
                    case CHAR: {
                        if (instanceType != TypeType.CHAR && instanceType != TypeType.CHAR_WRAPPER) continue block13;
                        score += 1000;
                        continue block13;
                    }
                    case STRING: {
                        if (instanceType == TypeType.STRING) {
                            score += 1000;
                            continue block13;
                        }
                        if (instanceType != TypeType.CHAR_SEQUENCE && !(arg instanceof CharSequence)) continue block13;
                        score += 500;
                        continue block13;
                    }
                    case INSTANCE: {
                        if (instanceType == TypeType.INSTANCE) {
                            if (!m.parameterTypes()[argIndex].isInstance(arg)) continue block13;
                            score += 1000;
                            continue block13;
                        }
                        if (instanceType == TypeType.MAP) {
                            score += 1000;
                            continue block13;
                        }
                        if (instanceType != TypeType.LIST) continue block13;
                        score += 500;
                        continue block13;
                    }
                    default: {
                        if (instanceType == type) {
                            score += 1000;
                            continue block13;
                        }
                        if (!m.parameterTypes()[argIndex].isInstance(arg)) continue block13;
                        score += 1000;
                    }
                }
            }
            if (score <= maxScore) continue;
            maxScore = score;
            methodAccess = m;
        }
        if (methodAccess != null) {
            return methodAccess.invokeDynamic(object, args);
        }
        List<MethodAccess> varargMethods = this.methodAccessListByArgNumberWithVarArg.get(0);
        if (varargMethods != null) {
            varargMethods.get(0).invokeDynamic(args, new Object[0]);
        }
        return null;
    }

    private int handleLongArg(int score, Object arg, TypeType instanceType) {
        switch (instanceType) {
            case LONG: {
                score += 1000;
                break;
            }
            case LONG_WRAPPER: {
                score += 1000;
                break;
            }
            case INT: {
                score += 800;
                break;
            }
            case INTEGER_WRAPPER: {
                score += 700;
                break;
            }
            case DOUBLE: {
                score += 700;
                break;
            }
            case BYTE: 
            case SHORT: 
            case FLOAT: {
                score += 600;
                break;
            }
            case BYTE_WRAPPER: 
            case SHORT_WRAPPER: 
            case FLOAT_WRAPPER: 
            case DOUBLE_WRAPPER: {
                score += 500;
                break;
            }
            case STRING: {
                score += 400;
                try {
                    arg = Integer.valueOf(arg.toString());
                    break;
                }
                catch (Exception ex) {
                    score = Integer.MIN_VALUE;
                }
            }
        }
        return score;
    }

    private int handleByteArg(int score, Object arg, TypeType instanceType) {
        if (instanceType == TypeType.BYTE || instanceType == TypeType.BYTE_WRAPPER) {
            return score + 1010;
        }
        return this.handleIntArg(score, arg, instanceType);
    }

    private int handleShortArg(int score, Object arg, TypeType instanceType) {
        if (instanceType == TypeType.SHORT || instanceType == TypeType.SHORT_WRAPPER) {
            return score + 1010;
        }
        return this.handleIntArg(score, arg, instanceType);
    }

    private int handleIntArg(int score, Object arg, TypeType instanceType) {
        switch (instanceType) {
            case INT: {
                score += 1000;
                break;
            }
            case INTEGER_WRAPPER: {
                score += 900;
                break;
            }
            case BYTE: 
            case SHORT: {
                score += 800;
                break;
            }
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                score += 700;
                break;
            }
            case BYTE_WRAPPER: 
            case SHORT_WRAPPER: {
                score += 600;
                break;
            }
            case LONG_WRAPPER: 
            case FLOAT_WRAPPER: 
            case DOUBLE_WRAPPER: {
                score += 500;
                break;
            }
            case STRING: {
                score += 400;
                try {
                    arg = Integer.valueOf(arg.toString());
                    break;
                }
                catch (Exception ex) {
                    score = Integer.MIN_VALUE;
                }
            }
        }
        return score;
    }

    private int handleFloatArg(int score, Object arg, TypeType instanceType) {
        switch (instanceType) {
            case FLOAT: {
                score += 1000;
                break;
            }
            case FLOAT_WRAPPER: {
                score += 900;
                break;
            }
            case BYTE: 
            case SHORT: {
                score += 800;
                break;
            }
            case DOUBLE: {
                score += 700;
                break;
            }
            case BYTE_WRAPPER: 
            case SHORT_WRAPPER: 
            case INT: 
            case LONG: {
                score += 600;
                break;
            }
            case INTEGER_WRAPPER: 
            case LONG_WRAPPER: 
            case DOUBLE_WRAPPER: {
                score += 500;
                break;
            }
            case STRING: {
                score += 400;
                try {
                    arg = Float.valueOf(arg.toString());
                    break;
                }
                catch (Exception ex) {
                    score = Integer.MIN_VALUE;
                }
            }
        }
        return score;
    }

    private int handleDoubleArg(int score, Object arg, TypeType instanceType) {
        switch (instanceType) {
            case DOUBLE: {
                score += 1000;
                break;
            }
            case DOUBLE_WRAPPER: {
                score += 900;
                break;
            }
            case BYTE: 
            case SHORT: {
                score += 800;
                break;
            }
            case FLOAT: {
                score += 700;
                break;
            }
            case BYTE_WRAPPER: 
            case SHORT_WRAPPER: 
            case INT: 
            case LONG: {
                score += 600;
                break;
            }
            case INTEGER_WRAPPER: 
            case LONG_WRAPPER: 
            case FLOAT_WRAPPER: {
                score += 500;
                break;
            }
            case STRING: {
                score += 400;
                try {
                    arg = Double.valueOf(arg.toString());
                    break;
                }
                catch (Exception ex) {
                    score = Integer.MIN_VALUE;
                }
            }
        }
        return score;
    }

    @Override
    public Object invoke(Object object, Object ... args) {
        return null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public Class<?> declaringType() {
        return null;
    }

    @Override
    public Class<?> returnType() {
        return null;
    }

    @Override
    public boolean respondsTo(Class<?> ... types) {
        return false;
    }

    @Override
    public boolean respondsTo(Object ... args) {
        return false;
    }

    @Override
    public Object invokeStatic(Object ... args) {
        return null;
    }

    @Override
    public MethodAccess bind(Object instance) {
        return null;
    }

    @Override
    public MethodHandle methodHandle() {
        return null;
    }

    @Override
    public MethodAccess methodAccess() {
        return null;
    }

    @Override
    public Object bound() {
        return null;
    }

    @Override
    public <T> ConstantCallSite invokeReducerLongIntReturnLongMethodHandle(T object) {
        return null;
    }

    @Override
    public Method method() {
        return null;
    }

    @Override
    public int score() {
        return 0;
    }

    @Override
    public List<TypeType> paramTypeEnumList() {
        return Collections.emptyList();
    }

    @Override
    public Object invokeDynamicObject(Object object, Object args) {
        if (args instanceof List) {
            return this.invokeDynamicList(object, (List)args);
        }
        return this.invokeDynamic(object, args);
    }

    @Override
    public List<List<AnnotationData>> annotationDataForParams() {
        return null;
    }

    public Object invokeDynamicList(Object object, List<?> args) {
        return this.invokeDynamic(object, Arry.objectArray(args));
    }

    @Override
    public Class<?>[] parameterTypes() {
        return new Class[0];
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return new Type[0];
    }

    @Override
    public Iterable<AnnotationData> annotationData() {
        return null;
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return false;
    }

    @Override
    public AnnotationData annotation(String annotationName) {
        return null;
    }

    @Override
    public int compareTo(MethodAccess o) {
        return 0;
    }
}

