/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.boon.cache.Cache;
import org.boon.cache.CacheType;
import org.boon.cache.SimpleCache;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.MethodAccess;
import org.boon.primitive.Int;

public class SimpleConcurrentCache<K, V>
implements Cache<K, V> {
    final SimpleCache<K, V>[] cacheRegions;
    private static final boolean useFastHash;
    private final transient int hashSeed = SimpleConcurrentCache.randomHashSeed(this);
    static final MethodAccess randomHashSeedMethod;

    public SimpleConcurrentCache(int limit) {
        this(limit, false, CacheType.LRU);
    }

    public SimpleConcurrentCache(int limit, CacheType type) {
        this(limit, false, type);
    }

    public SimpleConcurrentCache(int limit, boolean fair, CacheType type) {
        int cores = Runtime.getRuntime().availableProcessors();
        int stripeSize = cores < 2 ? 8 : cores * 4;
        stripeSize = Int.roundUpToPowerOf2(stripeSize);
        this.cacheRegions = new SimpleCache[stripeSize];
        for (int index = 0; index < this.cacheRegions.length; ++index) {
            this.cacheRegions[index] = new SimpleThreadSafeCache(limit / this.cacheRegions.length, type, fair);
        }
    }

    public SimpleConcurrentCache(int concurrency, int limit, boolean fair, CacheType type) {
        int stripeSize = Int.roundUpToPowerOf2(concurrency);
        this.cacheRegions = new SimpleCache[stripeSize];
        for (int index = 0; index < this.cacheRegions.length; ++index) {
            this.cacheRegions[index] = new SimpleThreadSafeCache(limit / this.cacheRegions.length, type, fair);
        }
    }

    public SimpleConcurrentCache(int concurrency, int limit, boolean fair) {
        int stripeSize = Int.roundUpToPowerOf2(concurrency);
        this.cacheRegions = new SimpleCache[stripeSize];
        for (int index = 0; index < this.cacheRegions.length; ++index) {
            this.cacheRegions[index] = new SimpleThreadSafeCache(limit / this.cacheRegions.length, CacheType.LRU, fair);
        }
    }

    private SimpleCache<K, V> map(K key) {
        return this.cacheRegions[this.stripeIndex(key)];
    }

    @Override
    public void put(K key, V value) {
        this.map(key).put(key, value);
    }

    @Override
    public V get(K key) {
        return this.map(key).get(key);
    }

    @Override
    public V getSilent(K key) {
        return this.map(key).getSilent(key);
    }

    @Override
    public void remove(K key) {
        this.map(key).remove(key);
    }

    @Override
    public int size() {
        int size = 0;
        for (SimpleCache<K, V> cache : this.cacheRegions) {
            size += cache.size();
        }
        return size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (SimpleCache<K, V> cache : this.cacheRegions) {
            builder.append(cache.toString()).append('\n');
        }
        return builder.toString();
    }

    private static int randomHashSeed(SimpleConcurrentCache instance) {
        if (useFastHash) {
            return (Integer)randomHashSeedMethod.invoke(instance, new Object[0]);
        }
        return 0;
    }

    private final int hash(Object k) {
        int h = this.hashSeed;
        h ^= k.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private int stripeIndex(K key) {
        return SimpleConcurrentCache.indexFor(this.hash(key), this.cacheRegions.length);
    }

    static {
        boolean yes;
        MethodAccess randomHashSeed = null;
        try {
            Class<?> cls = Class.forName("sun.misc.Hashing");
            ClassMeta<?> classMeta = ClassMeta.classMeta(cls);
            yes = classMeta.respondsTo("randomHashSeed", Object.class) && classMeta.classMethods().contains("randomHashSeed");
            randomHashSeed = classMeta.method("randomHashSeed");
        }
        catch (Exception ex) {
            yes = false;
        }
        useFastHash = yes;
        randomHashSeedMethod = randomHashSeed;
    }

    private static class SimpleThreadSafeCache<K, V>
    extends SimpleCache<K, V> {
        private final ReadWriteLock readWriteLock;

        SimpleThreadSafeCache(int limit, CacheType type, boolean fair) {
            super(limit, type);
            this.readWriteLock = new ReentrantReadWriteLock(fair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, V value) {
            this.readWriteLock.writeLock().lock();
            try {
                super.put(key, value);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(K key) {
            Object value;
            this.readWriteLock.writeLock().lock();
            try {
                value = super.get(key);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(K key) {
            this.readWriteLock.writeLock().lock();
            try {
                super.remove(key);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getSilent(K key) {
            Object value;
            this.readWriteLock.writeLock().lock();
            try {
                value = super.getSilent(key);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            this.readWriteLock.readLock().lock();
            int size = -1;
            try {
                size = super.size();
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            String str;
            this.readWriteLock.readLock().lock();
            try {
                str = super.toString();
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            return str;
        }
    }
}

