/*
 * Decompiled with CFR 0.152.
 */
package org.boon.logging;

import org.boon.core.Handler;
import org.boon.logging.HandlerNoOP;
import org.boon.logging.LogLevel;
import org.boon.logging.LogRecord;
import org.boon.logging.LoggerDelegate;
import org.boon.logging.TeeLoggerWrapper;
import org.boon.primitive.Arry;

public class ConfigurableLogger
implements LoggerDelegate {
    private volatile transient LoggerDelegate logger;
    private final Handler<LogRecord> handler;
    final LoggerDelegate original;
    public static final HandlerNoOP noOP = new HandlerNoOP();

    public synchronized void unwrap() {
        this.logger = this.original;
    }

    public ConfigurableLogger(LoggerDelegate delegate, Handler<LogRecord> logRecordHandler) {
        this.logger = delegate;
        this.handler = logRecordHandler;
        this.original = this.logger;
    }

    public ConfigurableLogger(LoggerDelegate delegate) {
        this.logger = delegate;
        this.handler = noOP;
        this.original = this.logger;
    }

    public synchronized void tee(LoggerDelegate newLogger) {
        this.logger = new TeeLoggerWrapper(this.logger, newLogger);
    }

    public synchronized void handler(Handler<LogRecord> handler) {
        this.logger = new ConfigurableLogger(this.logger, handler);
    }

    public synchronized void teeAndHandler(LoggerDelegate newLogger, Handler<LogRecord> handler) {
        this.logger = new TeeLoggerWrapper(this.logger, newLogger);
    }

    @Override
    public boolean infoOn() {
        return this.logger.infoOn();
    }

    @Override
    public boolean debugOn() {
        return this.logger.debugOn();
    }

    @Override
    public boolean traceOn() {
        return this.logger.traceOn();
    }

    @Override
    public void fatal(Object message) {
        this.handler.handle(LogRecord.before(Arry.array(message), LogLevel.FATAL));
        this.logger.fatal(message);
        this.handler.handle(LogRecord.after(Arry.array(message), LogLevel.FATAL));
    }

    @Override
    public void fatal(Object message, Throwable throwable) {
        this.handler.handle(LogRecord.before(Arry.array(message), throwable, LogLevel.FATAL));
        this.logger.fatal(message, throwable);
        this.handler.handle(LogRecord.after(Arry.array(message), throwable, LogLevel.FATAL));
    }

    @Override
    public void error(Object message) {
        this.handler.handle(LogRecord.before(Arry.array(message), LogLevel.ERROR));
        this.logger.error(message);
        this.handler.handle(LogRecord.after(Arry.array(message), LogLevel.ERROR));
    }

    @Override
    public void error(Object message, Throwable throwable) {
        this.handler.handle(LogRecord.before(Arry.array(message), throwable, LogLevel.ERROR));
        this.logger.error(message, throwable);
        this.handler.handle(LogRecord.after(Arry.array(message), throwable, LogLevel.ERROR));
    }

    @Override
    public void warn(Object message) {
        this.handler.handle(LogRecord.before(Arry.array(message), LogLevel.WARN));
        this.logger.warn(message);
        this.handler.handle(LogRecord.after(Arry.array(message), LogLevel.WARN));
    }

    @Override
    public void warn(Object message, Throwable throwable) {
        this.handler.handle(LogRecord.before(Arry.array(message), throwable, LogLevel.WARN));
        this.logger.warn(message, throwable);
        this.handler.handle(LogRecord.after(Arry.array(message), throwable, LogLevel.WARN));
    }

    @Override
    public void info(Object message) {
        this.handler.handle(LogRecord.before(Arry.array(message), LogLevel.INFO));
        this.logger.info(message);
        this.handler.handle(LogRecord.after(Arry.array(message), LogLevel.INFO));
    }

    @Override
    public void info(Object message, Throwable throwable) {
        this.handler.handle(LogRecord.before(Arry.array(message), throwable, LogLevel.INFO));
        this.logger.info(message, throwable);
        this.handler.handle(LogRecord.after(Arry.array(message), throwable, LogLevel.INFO));
    }

    @Override
    public void debug(Object message) {
        this.handler.handle(LogRecord.before(Arry.array(message), LogLevel.DEBUG));
        this.logger.debug(message);
        this.handler.handle(LogRecord.after(Arry.array(message), LogLevel.DEBUG));
    }

    @Override
    public void debug(Object message, Throwable throwable) {
        this.handler.handle(LogRecord.before(Arry.array(message), throwable, LogLevel.DEBUG));
        this.logger.debug(message, throwable);
        this.handler.handle(LogRecord.after(Arry.array(message), throwable, LogLevel.DEBUG));
    }

    @Override
    public void trace(Object message) {
        this.handler.handle(LogRecord.before(Arry.array(message), LogLevel.TRACE));
        this.logger.trace(message);
        this.handler.handle(LogRecord.after(Arry.array(message), LogLevel.TRACE));
    }

    @Override
    public void trace(Object message, Throwable throwable) {
        this.handler.handle(LogRecord.before(Arry.array(message), throwable, LogLevel.TRACE));
        this.logger.trace(message, throwable);
        this.handler.handle(LogRecord.after(Arry.array(message), throwable, LogLevel.TRACE));
    }

    @Override
    public LoggerDelegate level(LogLevel level) {
        this.logger.level(level);
        return this;
    }

    @Override
    public LoggerDelegate turnOff() {
        this.logger.turnOff();
        return this;
    }

    @Override
    public void fatal(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.FATAL));
        this.logger.fatal(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.FATAL));
    }

    @Override
    public void fatal(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.FATAL));
        this.logger.fatal(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.FATAL));
    }

    @Override
    public void error(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.ERROR));
        this.logger.error(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.ERROR));
    }

    @Override
    public void error(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.ERROR));
        this.logger.error(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.ERROR));
    }

    @Override
    public void warn(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.WARN));
        this.logger.warn(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.WARN));
    }

    @Override
    public void warn(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.WARN));
        this.logger.warn(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.WARN));
    }

    @Override
    public void info(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.INFO));
        this.logger.info(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.INFO));
    }

    @Override
    public void info(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.INFO));
        this.logger.info(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.INFO));
    }

    @Override
    public void config(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.CONFIG));
        this.logger.config(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.CONFIG));
    }

    @Override
    public void config(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.CONFIG));
        this.logger.config(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.CONFIG));
    }

    @Override
    public void debug(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.DEBUG));
        this.logger.debug(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.DEBUG));
    }

    @Override
    public void debug(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.DEBUG));
        this.logger.debug(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.DEBUG));
    }

    @Override
    public void trace(Object ... messages) {
        this.handler.handle(LogRecord.before(messages, LogLevel.TRACE));
        this.logger.trace(messages);
        this.handler.handle(LogRecord.after(messages, LogLevel.TRACE));
    }

    @Override
    public void trace(Throwable throwable, Object ... messages) {
        this.handler.handle(LogRecord.before(messages, throwable, LogLevel.TRACE));
        this.logger.trace(throwable, messages);
        this.handler.handle(LogRecord.after(messages, throwable, LogLevel.TRACE));
    }
}

