/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di;

import java.util.List;
import java.util.Map;
import org.boon.Lists;
import org.boon.di.Context;
import org.boon.di.Module;
import org.boon.di.ProviderInfo;
import org.boon.di.impl.ContextImpl;
import org.boon.di.modules.InstanceModule;
import org.boon.di.modules.SupplierModule;

public class DependencyInjection {
    public static Context context(Module ... modules) {
        return new ContextImpl(modules);
    }

    public static Module classes(Class ... classes) {
        List<ProviderInfo> wrap = Lists.wrap(ProviderInfo.class, classes);
        return new SupplierModule(wrap);
    }

    public static Module objects(Object ... objects) {
        List<ProviderInfo> wrap = Lists.mapBy(objects, ProviderInfo.class, "objectProviderOf");
        return new SupplierModule(wrap);
    }

    public static Module prototypes(Object ... objects) {
        List<ProviderInfo> wrap = Lists.mapBy(objects, ProviderInfo.class, "prototypeProviderOf");
        return new SupplierModule(wrap);
    }

    public static Module module(Object module) {
        return new InstanceModule(module);
    }

    public static Module suppliers(ProviderInfo ... suppliers) {
        return new SupplierModule(suppliers);
    }

    public static Context fromMap(Map<?, ?> map) {
        return new ContextImpl(new SupplierModule(map));
    }
}

