/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Ok;
import org.boon.core.Conversions;
import org.boon.core.Predicate;
import org.boon.core.Typ;
import org.boon.core.TypeType;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Criterion;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Group;
import org.boon.criteria.internal.Not;
import org.boon.criteria.internal.Operator;

public class ObjectFilter {
    public static boolean matches(Object obj, Criteria ... exp) {
        return ObjectFilter.and(exp).test(obj);
    }

    public static boolean matches(Object obj, Predicate exp) {
        return exp.test(obj);
    }

    public static boolean matches(Object obj, List<Criteria> expressions) {
        return ObjectFilter.and(expressions.toArray(new Criteria[expressions.size()])).test(obj);
    }

    public static <T> List<T> filter(Collection<T> items, List<Criteria> expressions) {
        if (items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T item : items) {
            if (!ObjectFilter.and(expressions.toArray(new Criteria[expressions.size()])).test(item)) continue;
            results.add(item);
        }
        return results;
    }

    public static <T> List<T> filter(Collection<T> items, Criteria ... exp) {
        if (items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Group and = ObjectFilter.and(exp);
        ArrayList<T> results = new ArrayList<T>();
        for (T item : items) {
            if (!and.test(item)) continue;
            results.add(item);
        }
        return results;
    }

    public static Not not(Criteria expression) {
        return new Not(expression);
    }

    public static Group and(Criteria ... expressions) {
        return new Group.And(expressions);
    }

    public static Group or(Criteria ... expressions) {
        return new Group.Or(expressions);
    }

    public static Criterion eq(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                return Boon.equals(this.fieldValue(), this.value());
            }
        };
    }

    public static Criterion typeOf(final String className) {
        return new Criterion<Object>("_type", Operator.EQUAL, new Object[]{className}){

            @Override
            public boolean resolve(Object owner) {
                for (Class<?> cls = owner.getClass(); cls != Typ.object; cls = cls.getSuperclass()) {
                    Class<?>[] interfaces;
                    String simpleName = cls.getSimpleName();
                    String name = cls.getName();
                    if (simpleName.equals(className) || name.equals(className)) {
                        return true;
                    }
                    for (Class<?> i : interfaces = cls.getInterfaces()) {
                        simpleName = i.getSimpleName();
                        name = i.getName();
                        if (!simpleName.equals(className) && !name.equals(className)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Criterion instanceOf(final Class<?> cls) {
        return new Criterion<Object>("_type", Operator.EQUAL, new Object[]{cls.getName()}){

            @Override
            public boolean resolve(Object owner) {
                return Typ.isSuperClass(owner.getClass(), cls);
            }
        };
    }

    public static Criterion implementsInterface(final Class<?> cls) {
        return new Criterion<Object>("_type", Operator.EQUAL, new Object[]{cls.getName()}){

            @Override
            public boolean resolve(Object owner) {
                return Typ.implementsInterface(owner.getClass(), cls);
            }
        };
    }

    public static Criterion notEq(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.NOT_EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                return !this.fieldValue().equals(this.value());
            }
        };
    }

    public static Criterion notIn(Object name, Object ... values) {
        return new Criterion<Object>(name.toString(), Operator.NOT_IN, values){

            @Override
            public boolean resolve(Object owner) {
                Object fieldValue = this.fieldValue();
                if (this.value == null) {
                    return false;
                }
                return !this.valueSet().contains(fieldValue);
            }
        };
    }

    public static Criterion in(Object name, Object ... values) {
        return new Criterion<Object>(name.toString(), Operator.IN, values){

            @Override
            public boolean resolve(Object owner) {
                Object fieldValue = this.fieldValue();
                if (this.value == null) {
                    return false;
                }
                return this.valueSet().contains(fieldValue);
            }
        };
    }

    public static Criterion lt(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.LESS_THAN, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                return ((Comparable)this.value()).compareTo(this.fieldValue()) > 0;
            }
        };
    }

    public static Criterion lte(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                return ((Comparable)this.value()).compareTo(this.fieldValue()) >= 0;
            }
        };
    }

    public static Criterion gt(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.GREATER_THAN, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                return ((Comparable)this.value()).compareTo(this.fieldValue()) < 0;
            }
        };
    }

    public static Criterion gte(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                return ((Comparable)this.value()).compareTo(this.fieldValue()) <= 0;
            }
        };
    }

    public static Criterion between(Object name, Object value, Object value2) {
        return new Criterion<Object>(name.toString(), Operator.BETWEEN, new Object[]{value, value2}){

            @Override
            public boolean resolve(Object owner) {
                return ((Comparable)this.value()).compareTo(this.fieldValue()) <= 0 && ((Comparable)this.value2()).compareTo(this.fieldValue()) >= 0;
            }
        };
    }

    public static Criterion between(Class clazz, Object name, String svalue, String svalue2) {
        FieldAccess field = null;
        Criterion c = null;
        if (clazz != null) {
            field = BeanUtils.getField(clazz, name.toString());
        }
        if (field == null) {
            c = ObjectFilter.between(name, svalue, svalue2);
        } else {
            Object o = Conversions.coerce(field.type(), svalue);
            Object o2 = Conversions.coerce(field.type(), svalue2);
            c = ObjectFilter.between(name, o, o2);
        }
        return c;
    }

    public static Criterion startsWith(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.STARTS_WITH, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                Object fieldValue = this.fieldValue();
                if (fieldValue == null) {
                    return false;
                }
                return fieldValue.toString().startsWith(this.value.toString());
            }
        };
    }

    public static Criterion endsWith(Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.ENDS_WITH, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                Object fieldValue = this.fieldValue();
                if (fieldValue == null) {
                    return false;
                }
                return fieldValue.toString().startsWith(this.value.toString());
            }
        };
    }

    public static Criterion notContains(Object name, Object value) {
        return ObjectFilter.doContains(name, value, true);
    }

    public static Criterion contains(Object name, Object value) {
        return ObjectFilter.doContains(name, value, false);
    }

    private static Criterion doContains(Object name, Object value, final boolean not) {
        return new Criterion<Object>(name.toString(), not ? Operator.NOT_CONTAINS : Operator.CONTAINS, new Object[]{value}){

            @Override
            public boolean resolve(Object owner) {
                boolean returnVal;
                FieldAccess field = this.field();
                Object fieldValue = this.fieldValue();
                Object value = this.value();
                if (Typ.implementsInterface(field.type(), Typ.collection)) {
                    Collection collection = (Collection)fieldValue;
                    returnVal = collection.contains(value);
                } else if (field.type().isArray()) {
                    returnVal = false;
                    Object array = fieldValue;
                    Iterator iter = Boon.iterator(array);
                    while (iter.hasNext()) {
                        Object i = iter.next();
                        if (!i.equals(value)) continue;
                        returnVal = true;
                    }
                } else {
                    returnVal = fieldValue.toString().contains(value.toString());
                }
                return not ? !returnVal : returnVal;
            }
        };
    }

    public static Criterion notEmpty(Object name) {
        return ObjectFilter.doEmpty(name, true);
    }

    public static Criterion empty(Object name) {
        return ObjectFilter.doEmpty(name, false);
    }

    private static Criterion doEmpty(Object name, final boolean not) {
        return new Criterion<Object>(name.toString(), not ? Operator.NOT_EMPTY : Operator.IS_EMPTY, new Object[]{""}){
            String sValue;
            {
                super(x0, x1, x2);
                this.sValue = this.value instanceof String ? (String)this.value : this.value.toString();
            }

            @Override
            public boolean resolve(Object owner) {
                boolean returnVal;
                FieldAccess field = this.field();
                Object fieldValue = this.fieldValue();
                if (Typ.implementsInterface(field.type(), Typ.collection)) {
                    Collection collection = (Collection)fieldValue;
                    returnVal = collection == null || collection.isEmpty();
                } else if (field.type().isArray()) {
                    Object array = fieldValue;
                    returnVal = array == null || Boon.len(array) == 0;
                } else {
                    boolean bl = returnVal = fieldValue == null || Boon.len(fieldValue) == 0;
                }
                return not ? !returnVal : returnVal;
            }
        };
    }

    public static Criterion notNull(Object name) {
        return ObjectFilter.doIsNull(name, true);
    }

    public static Criterion isNull(Object name) {
        return ObjectFilter.doIsNull(name, false);
    }

    private static Criterion doIsNull(Object name, final boolean not) {
        return new Criterion<Object>(name.toString(), not ? Operator.NOT_NULL : Operator.IS_NULL, new Object[]{""}){

            @Override
            public boolean resolve(Object owner) {
                boolean isNull;
                Object fieldValue = this.fieldValue();
                boolean bl = isNull = fieldValue == null;
                return not ? !isNull : isNull;
            }
        };
    }

    public static Criterion eqInt(Object name, final int compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                return this.fieldInt() == compareValue;
            }
        };
    }

    public static Criterion notEqInt(Object name, final int compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                return this.fieldInt() != compareValue;
            }
        };
    }

    public static Criterion notInInts(Object name, final int ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                for (int compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inInts(Object name, final int ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                for (int compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltInt(Object name, final int compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteInt(Object name, final int compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtInt(Object name, final int compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteInt(Object name, final int compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenInt(Object name, final int start, final int stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Object owner) {
                int value = this.fieldInt();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqFloat(Object name, final float compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqFloat(Object name, final float compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value != compareValue;
            }
        };
    }

    public static Criterion notInFloats(Object name, final float ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                for (float compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inFloats(Object name, final float ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                for (float compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltFloat(Object name, final float compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteFloat(Object name, final float compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtFloat(Object name, final float compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteFloat(Object name, final float compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenFloat(Object name, final float start, final float stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{Float.valueOf(start), Float.valueOf(stop)}){

            @Override
            public boolean resolve(Object owner) {
                float value = this.fieldFloat();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqBoolean(Object name, final boolean compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                boolean value = this.fieldBoolean();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqBoolean(Object name, final boolean compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                boolean value = this.fieldBoolean();
                return value != compareValue;
            }
        };
    }

    public static Criterion eqDouble(Object name, final double compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqDouble(Object name, final double compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value != compareValue;
            }
        };
    }

    public static Criterion notInDoubles(Object name, final double ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                for (double compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inDoubles(Object name, final double ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                for (double compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltDouble(Object name, final double compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteDouble(Object name, final double compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtDouble(Object name, final double compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteDouble(Object name, final double compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenDouble(Object name, final double start, final double stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Object owner) {
                double value = this.fieldDouble();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqShort(Object name, final short compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqShort(Object name, final short compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value != compareValue;
            }
        };
    }

    public static Criterion notInShorts(Object name, final short ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                for (short compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inShorts(Object name, final short ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                for (short compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltShort(Object name, final short compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteShort(Object name, final short compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtShort(Object name, final short compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteShort(Object name, final short compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenShort(Object name, final short start, final short stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Object owner) {
                short value = this.fieldShort();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqByte(Object name, final byte compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqByte(Object name, final byte compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value != compareValue;
            }
        };
    }

    public static Criterion notInBytes(Object name, final byte ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                for (byte compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inBytes(Object name, final byte ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                for (byte compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltByte(Object name, final byte compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteByte(Object name, final byte compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtByte(Object name, final byte compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteByte(Object name, final byte compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenByte(Object name, final byte start, final byte stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Object owner) {
                byte value = this.fieldByte();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqLong(Object name, final long compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqLong(Object name, final long compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value != compareValue;
            }
        };
    }

    public static Criterion notInLongs(Object name, final long ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                for (long compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inLongs(Object name, final long ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                for (long compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltLong(Object name, final long compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteLong(Object name, final long compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtLong(Object name, final long compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteLong(Object name, final long compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{compareValue}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenLong(Object name, final long start, final long stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Object owner) {
                long value = this.fieldLong();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqChar(Object name, final char compareValue) {
        return new Criterion(name.toString(), Operator.EQUAL, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqChar(Object name, final char compareValue) {
        return new Criterion(name.toString(), Operator.NOT_EQUAL, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value != compareValue;
            }
        };
    }

    public static Criterion notInChars(Object name, final char ... compareValues) {
        return new Criterion(name.toString(), Operator.NOT_IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                for (char compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inChars(Object name, final char ... compareValues) {
        return new Criterion(name.toString(), Operator.IN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                for (char compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltChar(Object name, final char compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value < compareValue;
            }
        };
    }

    public static Criterion lteChar(Object name, final char compareValue) {
        return new Criterion(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtChar(Object name, final char compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value > compareValue;
            }
        };
    }

    public static Criterion gteChar(Object name, final char compareValue) {
        return new Criterion(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenChar(Object name, final char start, final char stop) {
        return new Criterion(name.toString(), Operator.BETWEEN, new Object[]{Character.valueOf(start), Character.valueOf(stop)}){

            @Override
            public boolean resolve(Object owner) {
                char value = this.fieldChar();
                return value >= start && value <= stop;
            }
        };
    }

    public static Criteria createCriteria(String name, Operator operator, TypeType type, Class<Object> classType, List<?> values) {
        Ok.okOrDie("Values must be passed", values);
        Object value = values.get(0);
        switch (operator) {
            case EQUAL: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.eqChar(name, Conversions.toChar(value));
                    }
                    case BYTE: {
                        return ObjectFilter.eqByte(name, Conversions.toByte(value));
                    }
                    case BOOLEAN: {
                        return ObjectFilter.eqBoolean(name, Conversions.toBoolean(value));
                    }
                    case INT: {
                        return ObjectFilter.eqInt(name, Conversions.toInt(value));
                    }
                    case FLOAT: {
                        return ObjectFilter.eqFloat(name, Conversions.toFloat(value));
                    }
                    case SHORT: {
                        return ObjectFilter.eqShort(name, Conversions.toShort(value));
                    }
                    case DOUBLE: {
                        return ObjectFilter.eqDouble(name, Conversions.toDouble(value));
                    }
                    case LONG: {
                        return ObjectFilter.eqLong(name, Conversions.toLong(value));
                    }
                }
                return ObjectFilter.eq(name, Conversions.coerce(classType, value));
            }
            case NOT_EQUAL: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.notEqChar(name, Conversions.toChar(value));
                    }
                    case BYTE: {
                        return ObjectFilter.notEqByte(name, Conversions.toByte(value));
                    }
                    case BOOLEAN: {
                        return ObjectFilter.notEqBoolean(name, Conversions.toBoolean(value));
                    }
                    case INT: {
                        return ObjectFilter.notEqInt(name, Conversions.toInt(value));
                    }
                    case FLOAT: {
                        return ObjectFilter.notEqFloat(name, Conversions.toFloat(value));
                    }
                    case SHORT: {
                        return ObjectFilter.notEqShort(name, Conversions.toShort(value));
                    }
                    case DOUBLE: {
                        return ObjectFilter.notEqDouble(name, Conversions.toDouble(value));
                    }
                    case LONG: {
                        return ObjectFilter.notEqLong(name, Conversions.toLong(value));
                    }
                }
                return ObjectFilter.notEq(name, Conversions.coerce(classType, value));
            }
            case GREATER_THAN: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.gtChar(name, Conversions.toChar(value));
                    }
                    case BYTE: {
                        return ObjectFilter.gtByte(name, Conversions.toByte(value));
                    }
                    case INT: {
                        return ObjectFilter.gtInt(name, Conversions.toInt(value));
                    }
                    case FLOAT: {
                        return ObjectFilter.gtFloat(name, Conversions.toFloat(value));
                    }
                    case SHORT: {
                        return ObjectFilter.gtShort(name, Conversions.toShort(value));
                    }
                    case DOUBLE: {
                        return ObjectFilter.gtDouble(name, Conversions.toDouble(value));
                    }
                    case LONG: {
                        return ObjectFilter.gtLong(name, Conversions.toLong(value));
                    }
                }
                return ObjectFilter.gt(name, Conversions.coerce(classType, value));
            }
            case LESS_THAN: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.ltChar(name, Conversions.toChar(value));
                    }
                    case BYTE: {
                        return ObjectFilter.ltByte(name, Conversions.toByte(value));
                    }
                    case INT: {
                        return ObjectFilter.ltInt(name, Conversions.toInt(value));
                    }
                    case FLOAT: {
                        return ObjectFilter.ltFloat(name, Conversions.toFloat(value));
                    }
                    case SHORT: {
                        return ObjectFilter.ltShort(name, Conversions.toShort(value));
                    }
                    case DOUBLE: {
                        return ObjectFilter.ltDouble(name, Conversions.toDouble(value));
                    }
                    case LONG: {
                        return ObjectFilter.ltLong(name, Conversions.toLong(value));
                    }
                }
                return ObjectFilter.lt(name, Conversions.coerce(classType, value));
            }
            case GREATER_THAN_EQUAL: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.gteChar(name, Conversions.toChar(value));
                    }
                    case BYTE: {
                        return ObjectFilter.gteByte(name, Conversions.toByte(value));
                    }
                    case INT: {
                        return ObjectFilter.gteInt(name, Conversions.toInt(value));
                    }
                    case FLOAT: {
                        return ObjectFilter.gteFloat(name, Conversions.toFloat(value));
                    }
                    case SHORT: {
                        return ObjectFilter.gteShort(name, Conversions.toShort(value));
                    }
                    case DOUBLE: {
                        return ObjectFilter.gteDouble(name, Conversions.toDouble(value));
                    }
                    case LONG: {
                        return ObjectFilter.gteLong(name, Conversions.toLong(value));
                    }
                }
                return ObjectFilter.gte(name, Conversions.coerce(classType, value));
            }
            case LESS_THAN_EQUAL: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.lteChar(name, Conversions.toChar(value));
                    }
                    case BYTE: {
                        return ObjectFilter.lteByte(name, Conversions.toByte(value));
                    }
                    case INT: {
                        return ObjectFilter.lteInt(name, Conversions.toInt(value));
                    }
                    case FLOAT: {
                        return ObjectFilter.lteFloat(name, Conversions.toFloat(value));
                    }
                    case SHORT: {
                        return ObjectFilter.lteShort(name, Conversions.toShort(value));
                    }
                    case DOUBLE: {
                        return ObjectFilter.lteDouble(name, Conversions.toDouble(value));
                    }
                    case LONG: {
                        return ObjectFilter.lteLong(name, Conversions.toLong(value));
                    }
                }
                return ObjectFilter.lte(name, Conversions.coerce(classType, value));
            }
            case BETWEEN: {
                Ok.okOrDie("Values must be at least 2 in size", values.size() > 1);
                Object value2 = values.get(1);
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.betweenChar(name, Conversions.toChar(value), Conversions.toChar(value2));
                    }
                    case BYTE: {
                        return ObjectFilter.betweenByte(name, Conversions.toByte(value), Conversions.toByte(value2));
                    }
                    case INT: {
                        return ObjectFilter.betweenInt(name, Conversions.toInt(value), Conversions.toInt(value2));
                    }
                    case FLOAT: {
                        return ObjectFilter.betweenFloat(name, Conversions.toFloat(value), Conversions.toFloat(value2));
                    }
                    case SHORT: {
                        return ObjectFilter.betweenShort(name, Conversions.toShort(value), Conversions.toShort(value2));
                    }
                    case DOUBLE: {
                        return ObjectFilter.betweenDouble(name, Conversions.toDouble(value), Conversions.toDouble(value2));
                    }
                    case LONG: {
                        return ObjectFilter.betweenLong(name, Conversions.toLong(value), Conversions.toLong(value2));
                    }
                }
                return ObjectFilter.between(name, Conversions.coerce(classType, value), Conversions.coerce(classType, value2));
            }
            case IN: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.inChars(name, Conversions.carray(values));
                    }
                    case BYTE: {
                        return ObjectFilter.inBytes(name, Conversions.barray(values));
                    }
                    case INT: {
                        return ObjectFilter.inInts(name, Conversions.iarray(values));
                    }
                    case FLOAT: {
                        return ObjectFilter.inFloats(name, Conversions.farray(values));
                    }
                    case SHORT: {
                        return ObjectFilter.inShorts(name, Conversions.sarray(values));
                    }
                    case DOUBLE: {
                        return ObjectFilter.inDoubles(name, Conversions.darray(values));
                    }
                    case LONG: {
                        return ObjectFilter.inLongs(name, Conversions.larray(values));
                    }
                }
                return ObjectFilter.in(name, Conversions.toArray(classType, values));
            }
            case NOT_IN: {
                switch (type) {
                    case CHAR: {
                        return ObjectFilter.notInChars(name, Conversions.carray(values));
                    }
                    case BYTE: {
                        return ObjectFilter.notInBytes(name, Conversions.barray(values));
                    }
                    case INT: {
                        return ObjectFilter.notInInts(name, Conversions.iarray(values));
                    }
                    case FLOAT: {
                        return ObjectFilter.notInFloats(name, Conversions.farray(values));
                    }
                    case SHORT: {
                        return ObjectFilter.notInShorts(name, Conversions.sarray(values));
                    }
                    case DOUBLE: {
                        return ObjectFilter.notInDoubles(name, Conversions.darray(values));
                    }
                    case LONG: {
                        return ObjectFilter.notInLongs(name, Conversions.larray(values));
                    }
                }
                return ObjectFilter.notIn(name, Conversions.toArray(classType, values));
            }
            case CONTAINS: {
                return ObjectFilter.contains(name, Conversions.coerce(classType, value));
            }
            case NOT_CONTAINS: {
                return ObjectFilter.notContains(name, Conversions.coerce(classType, value));
            }
            case STARTS_WITH: {
                return ObjectFilter.startsWith(name, value);
            }
            case ENDS_WITH: {
                return ObjectFilter.endsWith(name, value);
            }
            case NOT_EMPTY: {
                return ObjectFilter.notEmpty(name);
            }
            case IS_EMPTY: {
                return ObjectFilter.empty(name);
            }
        }
        return Exceptions.die(Criteria.class, new Object[]{"Not Found", name, operator, type, values});
    }

    public static Criteria createCriteriaFromClass(String name, Class<?> cls, Operator operator, List<?> values) {
        if (operator == Operator.AND) {
            return new Group.And(cls, values);
        }
        if (operator == Operator.OR) {
            return new Group.Or(cls, values);
        }
        FieldAccess fieldAccess = BeanUtils.idxField(cls, name);
        return ObjectFilter.createCriteria(name, operator, fieldAccess.typeEnum(), fieldAccess.type(), values);
    }

    public static Criteria criteriaFromList(List<?> list) {
        ArrayList args = new ArrayList(list);
        Object o = Lists.atIndex(args, -1);
        if (!(o instanceof List)) {
            Lists.atIndex(args, -1, Collections.singletonList(o));
        }
        return (Criteria)Invoker.invokeFromList(ObjectFilter.class, "createCriteriaFromClass", args);
    }

    public static Criteria criteriaFromJson(String json) {
        return (Criteria)Invoker.invokeFromObject(ObjectFilter.class, "createCriteriaFromClass", Boon.fromJson(json));
    }
}

