/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.Lists;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.Reflection;
import org.boon.core.timer.TimeKeeper;
import org.boon.core.timer.TimeKeeperBasic;
import org.boon.json.JsonParserFactory;
import org.boon.logging.Logging;

public class Sys {
    public static ConcurrentHashMap<Object, Object> systemProperties = new ConcurrentHashMap<Object, Object>(System.getProperties());
    public static ConcurrentHashMap<String, String> env = new ConcurrentHashMap<String, String>(System.getenv());
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static final boolean inContainer;
    private static final boolean is1_7OorLater;
    private static final int buildNumber;
    private static final BigDecimal version;
    private static final boolean is1_7;
    private static final boolean is1_8;
    public static final Object DEFAULT_NULL_NOT_EMPTY;
    static final AtomicReference<TimeKeeper> timer;
    static boolean _oracleJVMAndUnix;
    private static final boolean oracleJVMAndUnix;

    public static void println(String message) {
        System.out.println(message);
    }

    public static void print(String message) {
        System.out.print(message);
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean is1_7OrLater() {
        return is1_7OorLater;
    }

    public static boolean is1_7() {
        return is1_7;
    }

    public static boolean is1_8() {
        return is1_8;
    }

    public static int buildNumber() {
        return buildNumber;
    }

    public static char windowsPathSeparator() {
        return '\\';
    }

    public static TimeKeeper timer() {
        return timer.get();
    }

    public static long time() {
        return timer.get().time();
    }

    private static boolean detectContainer() {
        boolean _inContainer;
        try {
            Class.forName("javax.servlet.http.HttpServlet");
            _inContainer = true;
        }
        catch (ClassNotFoundException e) {
            _inContainer = false;
        }
        if (!_inContainer) {
            try {
                Class.forName("javax.ejb.EJBContext");
                _inContainer = true;
            }
            catch (ClassNotFoundException e) {
                _inContainer = false;
            }
        }
        return _inContainer;
    }

    public static boolean inContainer() {
        return inContainer;
    }

    public static Object contextToHold() {
        return Lists.list(Reflection.contextToHold(), Annotations.contextToHold(), Logging.contextToHold());
    }

    public static String sysPropMultipleKeys(String ... keys) {
        for (String key : keys) {
            String value = Sys._sysProp(key, DEFAULT_NULL_NOT_EMPTY);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String sysProp(String key) {
        return Sys._sysProp(key, null);
    }

    public static String sysPropDefaultNull(String key) {
        return Sys._sysProp(key, DEFAULT_NULL_NOT_EMPTY);
    }

    public static String sysProp(String key, Object defaultValue) {
        return Sys._sysProp(key, defaultValue);
    }

    private static String _sysProp(String key, Object defaultValue) {
        String newKey;
        String property = (String)systemProperties.get(key);
        if (property == null && (property = env.get(key)) == null && (property = env.get(newKey = Str.underBarCase(key))) == null && defaultValue != DEFAULT_NULL_NOT_EMPTY) {
            property = Conversions.toString(defaultValue);
        }
        return property;
    }

    public static boolean sysPropBoolean(String key) {
        return Sys.sysProp(key, false);
    }

    public static boolean sysProp(String key, boolean defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toBoolean(property);
    }

    public static int sysPropInt(String key) {
        return Sys.sysProp(key, -1);
    }

    public static int sysProp(String key, int defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toInt(property);
    }

    public static File sysProp(String key, File defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return new File(property);
    }

    public static Path sysProp(String key, Path defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return IO.path(property);
    }

    public static int sysPropLong(String key) {
        return Sys.sysProp(key, -1);
    }

    public static long sysProp(String key, long defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toLong(property);
    }

    public static short sysPropShort(String key) {
        return Sys.sysProp(key, (short)-1);
    }

    public static short sysProp(String key, short defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toShort(property);
    }

    public static byte sysPropByte(String key) {
        return Sys.sysProp(key, (byte)-1);
    }

    public static byte sysProp(String key, byte defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toByte(property);
    }

    public static BigDecimal sysPropBigDecimal(String key) {
        return Sys.sysPropBigDecima(key, null);
    }

    public static BigDecimal sysPropBigDecima(String key, BigDecimal defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toBigDecimal(property);
    }

    public static BigInteger sysPropBigInteger(String key) {
        return Sys.sysPropBigInteger(key, null);
    }

    public static BigInteger sysPropBigInteger(String key, BigInteger defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toBigInteger(property);
    }

    public static <T extends Enum> T sysPropEnum(Class<T> cls, String key) {
        return Sys.sysProp(cls, key, null);
    }

    public static <T extends Enum> T sysProp(Class<T> cls, String key, T defaultValue) {
        String property = (String)systemProperties.get(key);
        if (property == null) {
            property = env.get(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = env.get(newKey);
        }
        if (property == null) {
            return defaultValue;
        }
        return Conversions.toEnum(cls, property);
    }

    public static String putSysProp(String key, Object value) {
        return (String)systemProperties.put(key, Conversions.toString(value));
    }

    public static boolean hasSysProp(String propertyName) {
        return systemProperties.containsKey(propertyName);
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static List<GarbageCollectorMXBean> gc() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static double loadAverage() {
        return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
    }

    public static long maxFileDescriptorCount() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getMaxFileDescriptorCount();
        }
        return -1L;
    }

    public static long openFileDescriptorCount() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getOpenFileDescriptorCount();
        }
        return -1L;
    }

    public static long committedVirtualMemorySize() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getCommittedVirtualMemorySize();
        }
        return -1L;
    }

    public static long totalSwapSpaceSize() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getTotalSwapSpaceSize();
        }
        return -1L;
    }

    public static long freeSwapSpaceSize() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getFreeSwapSpaceSize();
        }
        return -1L;
    }

    public static long processCpuTime() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getProcessCpuTime();
        }
        return -1L;
    }

    public static long freePhysicalMemorySize() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getFreePhysicalMemorySize();
        }
        return -1L;
    }

    public static long totalPhysicalMemorySize() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getTotalPhysicalMemorySize();
        }
        return -1L;
    }

    public static double systemCpuLoad() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getSystemCpuLoad();
        }
        return -1.0;
    }

    public static double processCpuLoad() {
        if (oracleJVMAndUnix) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return unix.getProcessCpuLoad();
        }
        return -1.0;
    }

    public static long uptime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public static long startTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    public static int pendingFinalizationCount() {
        return ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
    }

    public static MemoryUsage heapMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
    }

    public static MemoryUsage nonHeapMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
    }

    public static int threadPeakCount() {
        return ManagementFactory.getThreadMXBean().getPeakThreadCount();
    }

    public static int threadCount() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public static long threadsStarted() {
        return ManagementFactory.getThreadMXBean().getTotalStartedThreadCount();
    }

    public static long threadCPUTime() {
        return ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
    }

    public static long threadUserTime() {
        return ManagementFactory.getThreadMXBean().getCurrentThreadUserTime();
    }

    public static int threadDaemonCount() {
        return ManagementFactory.getThreadMXBean().getDaemonThreadCount();
    }

    public static <T> T loadFromFileLocation(Class<T> clazz, String ... fileLocations) {
        for (String fileLocation : fileLocations) {
            if (fileLocation == null || !IO.exists(fileLocation)) continue;
            try {
                return new JsonParserFactory().create().parseFile(clazz, fileLocation);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Exceptions.handle(ex, "Unable to read file from ", fileLocation);
                return null;
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Exceptions.handle(e, "Unable to create instance of " + clazz.getName());
            return null;
        }
    }

    static {
        DEFAULT_NULL_NOT_EMPTY = new Object();
        BigDecimal v = new BigDecimal("-1");
        int b = -1;
        String sversion = System.getProperty("java.version");
        int dash = sversion.indexOf("-");
        if (dash != -1) {
            sversion = sversion.substring(0, dash);
        }
        if (sversion.indexOf("_") != -1) {
            String[] split = sversion.split("_");
            try {
                String build;
                String ver = split[0];
                if (ver.startsWith("1.8")) {
                    v = new BigDecimal("1.8");
                }
                if (ver.startsWith("1.7")) {
                    v = new BigDecimal("1.7");
                }
                if (ver.startsWith("1.6")) {
                    v = new BigDecimal("1.6");
                }
                if (ver.startsWith("1.5")) {
                    v = new BigDecimal("1.5");
                }
                if (ver.startsWith("1.9")) {
                    v = new BigDecimal("1.9");
                }
                if ((build = split[1]).endsWith("-ea")) {
                    build = build.substring(0, build.length() - 3);
                }
                b = Integer.parseInt(build);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Unable to determine build number or version");
            }
        } else if ("1.8.0".equals(sversion)) {
            b = -1;
            v = new BigDecimal("1.8");
        } else {
            try {
                v = new BigDecimal(sversion);
                b = -1;
            }
            catch (Exception ex) {
                v = sversion.startsWith("1.7") ? new BigDecimal("1.7") : (sversion.startsWith("1.8") ? new BigDecimal("1.8") : new BigDecimal("-1.0"));
            }
        }
        buildNumber = b;
        version = v;
        is1_7OorLater = version.compareTo(new BigDecimal("1.7")) >= 0;
        is1_7 = version.compareTo(new BigDecimal("1.7")) == 0;
        is1_8 = version.compareTo(new BigDecimal("1.8")) == 0;
        timer = new AtomicReference<TimeKeeperBasic>(new TimeKeeperBasic());
        boolean forceInContainer = Boolean.parseBoolean(System.getProperty("org.boon.forceInContainer", "false"));
        boolean forceNoContainer = Boolean.parseBoolean(System.getProperty("org.boon.forceNoContainer", "false"));
        boolean _inContainer = forceNoContainer ? false : (forceInContainer ? true : Sys.detectContainer());
        inContainer = _inContainer;
        _oracleJVMAndUnix = false;
        try {
            Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            _oracleJVMAndUnix = true;
        }
        catch (ClassNotFoundException e) {
            _oracleJVMAndUnix = false;
        }
        oracleJVMAndUnix = _oracleJVMAndUnix;
    }
}

