/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.boon.Boon;
import org.boon.IO;
import org.boon.Lists;
import org.boon.Str;
import org.boon.StringScanner;

public class Runner {
    private static final String shell;
    private static final String shellArgument;

    public static List<Path> path() {
        String[] paths = StringScanner.splitByDelimiters(System.getenv().get("PATH"), ":;");
        return Lists.mapBy(paths, IO.convertToPathFunction);
    }

    public static int exec(String ... args) {
        ProcessRunner runner = new ProcessRunner(null, null, 0, null, false, args);
        return runner.exec();
    }

    public static int exec(int timeout, String ... args) {
        ProcessRunner runner = new ProcessRunner(null, null, timeout, null, false, args);
        return runner.exec();
    }

    public static String run(int timeout, String ... args) {
        return Runner.run(timeout, null, args);
    }

    public static String runAt(String cwd, int timeout, String ... args) {
        return Runner.runAt(cwd, timeout, null, args);
    }

    public static String run(int timeout, List<Path> path, String ... args) {
        return Runner.doRun(timeout, path, false, args);
    }

    public static String runAt(String cwd, int timeout, List<Path> path, String ... args) {
        return Runner.doRunAt(cwd, timeout, path, false, args);
    }

    public static ProcessOut runProcess(int timeout, List<Path> path, boolean verbose, String ... args) {
        return Runner.runProcessAt(null, timeout, path, verbose, args);
    }

    public static ProcessOut runProcessAt(String cwd, int timeout, List<Path> path, boolean verbose, String ... args) {
        ProcessOut out = new ProcessOut();
        ProcessRunner runner = new ProcessRunner(null, null, timeout, path, verbose, args);
        runner.cwd = cwd;
        out.exit = runner.exec();
        out.stdout = runner.stdOut();
        out.stderr = runner.stdErr();
        out.commandLine = Str.joinCollection(' ', runner.commandLine);
        return out;
    }

    private static String doRun(int timeout, List<Path> path, boolean verbose, String ... args) {
        ProcessOut out = Runner.runProcess(timeout, path, verbose, args);
        if (out.getExit() != 0) {
            throw new ProcessException(Boon.sputs("EXIT CODE", out.getExit(), out.getStderr()));
        }
        return out.getStdout();
    }

    private static String doRunAt(String cwd, int timeout, List<Path> path, boolean verbose, String ... args) {
        ProcessOut out = Runner.runProcessAt(cwd, timeout, path, verbose, args);
        if (out.getExit() != 0) {
            throw new ProcessException(Boon.sputs("EXIT CODE", out.getExit(), out.getStderr()));
        }
        return out.getStdout();
    }

    public static ProcessInOut launchProcess(int timeout, List<Path> path, boolean verbose, String ... args) {
        ProcessInOut process = new ProcessInOut();
        process.run(timeout, path, verbose, args);
        return process;
    }

    public static String run(String ... args) {
        return Runner.run(0, args);
    }

    public static String runAt(String cwd, String ... args) {
        return Runner.runAt(cwd, 0, args);
    }

    public static String runShell(String ... args) {
        ArrayList<String> list = new ArrayList<String>(args.length + 2);
        list.add(shell);
        list.add(shellArgument);
        for (String arg : args) {
            list.add(arg);
        }
        return Runner.run(0, list.toArray(new String[list.size()]));
    }

    public static String runShell(int timeout, String ... args) {
        ArrayList<String> list = new ArrayList<String>(args.length + 2);
        list.add(shell);
        list.add(shellArgument);
        for (String arg : args) {
            list.add(arg);
        }
        return Runner.run(timeout, list.toArray(new String[list.size()]));
    }

    public static int execShell(String ... args) {
        ArrayList<String> list = new ArrayList<String>(args.length + 2);
        list.add(shell);
        list.add(shellArgument);
        for (String arg : args) {
            list.add(arg);
        }
        return Runner.exec(0, list.toArray(new String[list.size()]));
    }

    public static int execShell(int timeout, String ... args) {
        ArrayList<String> list = new ArrayList<String>(args.length + 2);
        list.add(shell);
        list.add(shellArgument);
        for (String arg : args) {
            list.add(arg);
        }
        return Runner.exec(timeout, list.toArray(new String[list.size()]));
    }

    private static void handle(Exception ex) {
        throw new ProcessException(ex);
    }

    static {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            shell = "cmd.exe";
            shellArgument = "/C";
        } else {
            shell = "/bin/sh";
            shellArgument = "-c";
        }
    }

    static class ProcessIODrainer
    implements Runnable {
        private Scanner fromProcess;
        private String password;
        private PrintWriter toProcess;
        private StringBuilder outputBuffer = new StringBuilder(1024);
        private boolean sudo;
        private boolean verbose;
        private BlockingQueue<String> queue;

        ProcessIODrainer(Scanner fromProcess, boolean verbose) {
            this.fromProcess = fromProcess;
            this.verbose = verbose;
        }

        ProcessIODrainer(BlockingQueue<String> queueOut, Scanner fromProcess, boolean verbose) {
            this.queue = queueOut;
            this.fromProcess = fromProcess;
            this.verbose = verbose;
        }

        ProcessIODrainer(Scanner fromProcess, PrintWriter toProcess, String password, boolean sudo, boolean verbose) {
            this.sudo = sudo;
            this.fromProcess = fromProcess;
            this.toProcess = toProcess;
            this.verbose = verbose;
            this.password = password;
        }

        public ProcessIODrainer(BlockingQueue<String> queueOut, Scanner fromProcess, PrintWriter toProcess, String password, boolean sudo, boolean verbose) {
            this.queue = queueOut;
            this.sudo = sudo;
            this.fromProcess = fromProcess;
            this.toProcess = toProcess;
            this.verbose = verbose;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.sudo) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                this.toProcess.println(this.password);
                this.toProcess.flush();
            }
            try {
                while (this.fromProcess.hasNextLine()) {
                    String line = this.fromProcess.nextLine();
                    if (this.queue != null) {
                        while (true) {
                            try {
                                this.queue.put(line);
                            }
                            catch (InterruptedException e) {
                                if (!Thread.currentThread().isInterrupted()) continue;
                            }
                            break;
                        }
                    }
                    if (this.verbose) {
                        Boon.puts(line);
                    }
                    this.outputBuffer.append(line).append('\n');
                }
            }
            finally {
                this.fromProcess.close();
            }
        }

        public String getOutput() {
            return this.outputBuffer.toString();
        }
    }

    public static class ProcessRunner {
        private List<String> commandLine;
        private String password;
        private List<Path> path;
        private ProcessIODrainer fromProcessOutput;
        private ProcessIODrainer fromProcessError;
        private int timeoutInSeconds = 0;
        private boolean verbose;
        private PrintWriter toProcess;
        private ProcessInOut inout;
        private Process process;
        private ExecutorService executorService;
        private ScheduledExecutorService scheduledExecutorService;
        private String cwd;

        public ProcessRunner(ProcessInOut inout, String password, int timeoutInSeconds, List<Path> path, boolean verbose, String ... cmdLine) {
            if (timeoutInSeconds == 0) {
                timeoutInSeconds = 5;
            }
            if (cmdLine.length == 1) {
                cmdLine = Str.split(cmdLine[0]);
            }
            this.inout = inout;
            this.commandLine = Lists.list(cmdLine);
            this.password = password;
            this.timeoutInSeconds = timeoutInSeconds;
            this.path = path;
            this.verbose = verbose;
            if (this.path == null) {
                this.path = Runner.path();
            }
            this.executorService = Executors.newFixedThreadPool(2);
        }

        public int exec() throws ProcessException {
            int exit = -666;
            this.initializePath();
            ProcessBuilder processBuilder = new ProcessBuilder(this.commandLine);
            if (this.cwd != null) {
                processBuilder.directory(new File(this.cwd));
            }
            String envPath = Str.joinCollection(File.pathSeparatorChar, this.path);
            processBuilder.environment().put("PATH", envPath);
            try {
                this.initializeDrainersScannersAndWriters(processBuilder);
                Future<?> fromProcessErrorFuture = this.executorService.submit(this.fromProcessError);
                Future<?> fromProcessOutputFuture = this.executorService.submit(this.fromProcessOutput);
                exit = this.timeoutInSeconds == -1 ? this.process.waitFor() : this.runWithTimeoutTimer(fromProcessErrorFuture, fromProcessOutputFuture);
                fromProcessErrorFuture.get();
                fromProcessOutputFuture.get();
            }
            catch (Exception e) {
                Thread.interrupted();
                Runner.handle(e);
            }
            return exit;
        }

        private void initializePath() {
            String cmd = this.commandLine.get(0);
            Path pathCommand = IO.path(cmd);
            if (!Files.exists(pathCommand, new LinkOption[0])) {
                for (Path dir : this.path) {
                    pathCommand = IO.path(dir, cmd);
                    if (!Files.exists(pathCommand, new LinkOption[0])) continue;
                    cmd = pathCommand.toAbsolutePath().toString();
                    break;
                }
            }
            this.commandLine.set(0, cmd);
        }

        private void initializeDrainersScannersAndWriters(ProcessBuilder processBuilder) throws IOException {
            this.process = processBuilder.start();
            this.toProcess = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream()));
            Scanner stdOut = new Scanner(this.process.getInputStream());
            Scanner stdErr = new Scanner(this.process.getErrorStream());
            if (this.inout == null) {
                this.fromProcessError = new ProcessIODrainer(stdErr, this.verbose);
                this.fromProcessOutput = new ProcessIODrainer(stdOut, this.toProcess, this.password, false, this.verbose);
            } else {
                this.fromProcessError = new ProcessIODrainer(this.inout.queueErr, stdErr, this.verbose);
                this.fromProcessOutput = new ProcessIODrainer(this.inout.queueOut, stdOut, this.toProcess, this.password, false, this.verbose);
            }
        }

        private int runWithTimeoutTimer(final Future<?> fromProcessErrorFuture, final Future<?> fromProcessOutputFuture) throws InterruptedException {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    ProcessRunner.this.process.destroy();
                    fromProcessErrorFuture.cancel(true);
                    fromProcessOutputFuture.cancel(true);
                }
            };
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(command, this.timeoutInSeconds, this.timeoutInSeconds, TimeUnit.SECONDS);
            int exit = this.process.waitFor();
            scheduledFuture.cancel(true);
            return exit;
        }

        public String stdOut() {
            return this.fromProcessOutput.getOutput();
        }

        public String stdErr() {
            return this.fromProcessError.getOutput();
        }
    }

    public static class ProcessException
    extends RuntimeException {
        public ProcessException() {
        }

        public ProcessException(String m, Throwable t) {
            super(m, t);
        }

        public ProcessException(String m) {
            super(m);
        }

        public ProcessException(Throwable t) {
            super(t);
        }
    }

    public static class ProcessOut {
        private int exit;
        private String stdout;
        private String stderr;
        private String commandLine;

        public int getExit() {
            return this.exit;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public String toString() {
            return "ProcessOut [\nexit=" + this.exit + ", \nstdout=" + this.stdout + ", \nstderr=" + this.stderr + ", \ncommandLine=" + this.commandLine + "\n]";
        }
    }

    public static class ProcessInOut {
        private ProcessRunner runner;
        private ProcessOut out;
        private AtomicBoolean done = new AtomicBoolean(false);
        private BlockingQueue<String> queueOut = new ArrayBlockingQueue<String>(100);
        private BlockingQueue<String> queueErr = new ArrayBlockingQueue<String>(100);
        private ExecutorService executorService;

        public void run(int timeout, List<Path> path, boolean verbose, String ... args) {
            this.done.set(false);
            this.out = new ProcessOut();
            this.runner = new ProcessRunner(this, null, timeout, path, verbose, args);
            this.executorService = Executors.newSingleThreadExecutor();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    ProcessInOut.this.out.exit = ProcessInOut.this.runner.exec();
                    ProcessInOut.this.out.stdout = ProcessInOut.this.runner.stdOut();
                    ProcessInOut.this.out.stderr = ProcessInOut.this.runner.stdErr();
                    ProcessInOut.this.out.commandLine = Str.joinCollection(' ', ProcessInOut.this.runner.commandLine);
                    ProcessInOut.this.done.set(true);
                }
            };
            this.executorService.submit(task);
        }

        public boolean isDone() {
            return this.done.get();
        }

        public ProcessOut processOut() {
            return this.out;
        }

        public BlockingQueue<String> getStdOut() {
            return this.queueOut;
        }

        public BlockingQueue<String> getStdErr() {
            return this.queueErr;
        }

        public void kill() {
            this.runner.process.destroy();
        }
    }
}

