/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.xml;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class GluuErrorHandler
implements ErrorHandler {
    private boolean result = true;
    private final List<String> validationLog = new ArrayList<String>();

    public boolean isValid() {
        return this.result;
    }

    public List<String> getLog() {
        return this.validationLog.isEmpty() ? null : this.validationLog;
    }

    @Override
    public void error(SAXParseException arg0) {
        this.result = false;
        this.validationLog.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()) + " : ERROR : " + arg0.getMessage());
    }

    @Override
    public void fatalError(SAXParseException arg0) {
        this.result = false;
        this.validationLog.add(new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss").format(Calendar.getInstance().getTime()) + " : FATAL : " + arg0.getMessage());
    }

    @Override
    public void warning(SAXParseException arg0) {
        this.validationLog.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()) + " : WARNING :" + arg0.getMessage());
    }
}

