/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.security;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

public class PropertiesDecrypter {
    private static final Logger log = LoggerFactory.getLogger(PropertiesDecrypter.class);
    public static final String bindPassword = "bindPassword";

    public static Properties decryptProperties(Properties properties, String encryptionKey) {
        try {
            return PropertiesDecrypter.decryptProperties(StringEncrypter.defaultInstance(), properties, encryptionKey);
        }
        catch (StringEncrypter.EncryptionException ex) {
            log.error(String.format("Failed to decript '%s' property", bindPassword), ex);
            return properties;
        }
    }

    public static Properties decryptProperties(StringEncrypter stringEncrypter, Properties properties) {
        return PropertiesDecrypter.decryptProperties(stringEncrypter, properties, null);
    }

    public static Properties decryptProperties(StringEncrypter stringEncrypter, Properties properties, String encryptionKey) {
        if (properties == null) {
            return properties;
        }
        Properties clondedProperties = (Properties)properties.clone();
        String encryptedPassword = clondedProperties.getProperty(bindPassword);
        if (StringHelper.isEmpty(encryptedPassword)) {
            return properties;
        }
        try {
            String decryptedProperty = StringHelper.isEmpty(encryptionKey) ? stringEncrypter.decrypt(properties.getProperty(bindPassword)) : stringEncrypter.decrypt(properties.getProperty(bindPassword), encryptionKey);
            clondedProperties.put(bindPassword, decryptedProperty);
        }
        catch (StringEncrypter.EncryptionException ex) {
            log.error(String.format("Failed to decript '%s' property", bindPassword), ex);
        }
        return clondedProperties;
    }

    public static String decryptProperty(String encryptedValue, boolean returnSource, String encryptionKey) {
        String resultValue;
        block3: {
            if (encryptedValue == null) {
                return encryptedValue;
            }
            resultValue = returnSource ? encryptedValue : null;
            try {
                resultValue = StringEncrypter.defaultInstance().decrypt(encryptedValue, encryptionKey);
            }
            catch (Exception ex) {
                if (returnSource) break block3;
                log.error(String.format("Failed to decrypt value: '%s'", encryptedValue, ex));
            }
        }
        return resultValue;
    }
}

