/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rs.protect.resteasy;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.xdi.oxauth.client.uma.PermissionRegistrationService;
import org.xdi.oxauth.client.uma.ResourceSetRegistrationService;
import org.xdi.oxauth.client.uma.RptStatusService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.UmaConfigurationService;
import org.xdi.oxauth.model.uma.UmaConfiguration;

public class ServiceProvider {
    public static final String WELL_KNOWN_UMA_PATH = "/.well-known/uma-configuration";
    private static final Logger LOG = Logger.getLogger(ServiceProvider.class);
    private final String opHost;
    private final ClientExecutor clientExecutor;
    private UmaConfiguration umaConfiguration = null;
    private UmaConfigurationService configurationService = null;
    private ResourceSetRegistrationService resourceSetRegistrationService = null;
    private PermissionRegistrationService permissionRegistrationService;
    private RptStatusService rptStatusService;

    public ServiceProvider(String opHost) {
        this(opHost, true);
    }

    public ServiceProvider(String opHost, boolean trustAll) {
        this(opHost, trustAll ? new ApacheHttpClient4Executor(ServiceProvider.createHttpClientTrustAll()) : new ApacheHttpClient4Executor());
    }

    public ServiceProvider(String opHost, ClientExecutor clientExecutor) {
        this.opHost = opHost;
        this.clientExecutor = clientExecutor;
    }

    public synchronized RptStatusService getRptStatusService() {
        if (this.rptStatusService == null) {
            this.rptStatusService = UmaClientFactory.instance().createRptStatusService(this.umaConfiguration, this.clientExecutor);
        }
        return this.rptStatusService;
    }

    public synchronized UmaConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = UmaClientFactory.instance().createMetaDataConfigurationService(this.opHost + WELL_KNOWN_UMA_PATH, this.clientExecutor);
        }
        return this.configurationService;
    }

    public synchronized UmaConfiguration getUmaConfiguration() {
        if (this.umaConfiguration == null) {
            this.umaConfiguration = this.getConfigurationService().getMetadataConfiguration();
        }
        return this.umaConfiguration;
    }

    public synchronized ResourceSetRegistrationService getResourceSetRegistrationService() {
        if (this.resourceSetRegistrationService == null) {
            this.resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.getUmaConfiguration(), this.clientExecutor);
        }
        return this.resourceSetRegistrationService;
    }

    public synchronized PermissionRegistrationService getPermissionRegistrationService() {
        if (this.permissionRegistrationService == null) {
            this.permissionRegistrationService = UmaClientFactory.instance().createResourceSetPermissionRegistrationService(this.getUmaConfiguration(), this.clientExecutor);
        }
        return this.permissionRegistrationService;
    }

    public String getOpHost() {
        return this.opHost;
    }

    public String opHostWithoutProtocol() {
        if (StringUtils.contains(this.opHost, "//")) {
            return StringUtils.substringAfter(this.opHost, "//");
        }
        return this.opHost;
    }

    public ClientExecutor getClientExecutor() {
        return this.clientExecutor;
    }

    public static HttpClient createHttpClientTrustAll() {
        try {
            SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, new X509HostnameVerifier(){

                @Override
                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                @Override
                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                @Override
                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
            registry.register(new Scheme("https", 443, sf));
            SingleClientConnManager ccm = new SingleClientConnManager(registry);
            return new DefaultHttpClient(ccm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

