/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.rs.protect;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.xdi.oxd.rs.protect.Condition;

public class RsResource
implements Serializable {
    @JsonProperty(value="path")
    String path;
    @JsonProperty(value="conditions")
    List<Condition> conditions;
    private Map<String, Condition> httpMethodToCondition = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<String> scopes(String httpMethod) {
        return this.getConditionMap().get(httpMethod).getScopes();
    }

    public List<String> scopesForTicket(String httpMethod) {
        Condition condition = this.getConditionMap().get(httpMethod);
        return condition.getTicketScopes() != null && !condition.getTicketScopes().isEmpty() ? condition.getTicketScopes() : condition.getScopes();
    }

    private Map<String, Condition> getConditionMap() {
        if (this.httpMethodToCondition == null) {
            this.initMap();
        }
        return this.httpMethodToCondition;
    }

    private void initMap() {
        this.httpMethodToCondition = Maps.newHashMap();
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (condition.getHttpMethods() == null) continue;
                for (String httpMethod : condition.getHttpMethods()) {
                    this.httpMethodToCondition.put(httpMethod, condition);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RsResource");
        sb.append("{path='").append(this.path).append('\'');
        sb.append(", conditions=").append(this.conditions);
        sb.append(", httpMethodToCondition=").append(this.httpMethodToCondition);
        sb.append('}');
        return sb.toString();
    }
}

