/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.ReadResult;

public class TransportClient {
    private static final Logger LOG = LoggerFactory.getLogger(TransportClient.class);
    private final Socket m_socket;
    private final PrintWriter m_out;
    private final BufferedReader m_in;

    public TransportClient(String p_host, int p_port) throws IOException {
        this.m_socket = new Socket(p_host, p_port);
        this.m_out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.m_socket.getOutputStream(), "UTF-8")), true);
        this.m_in = new BufferedReader(new InputStreamReader(this.m_socket.getInputStream(), "UTF-8"));
    }

    public String sendCommand(String p_command) throws IOException {
        if (StringUtils.isBlank(p_command)) {
            throw new IllegalArgumentException("It's not allowed to send blank/empty command.");
        }
        String lengthString = CoreUtils.normalizeLengthPrefixString(p_command.length());
        StringBuilder sb = new StringBuilder(lengthString);
        sb.append(p_command);
        String toSend = sb.toString();
        LOG.trace("Send: {}", (Object)toSend);
        this.m_out.print(toSend);
        this.m_out.flush();
        ReadResult readResult = CoreUtils.readCommand("", this.m_in);
        LOG.trace("Response: {}", (Object)readResult);
        return readResult != null ? readResult.getCommand() : null;
    }

    public void close() {
        IOUtils.closeQuietly(this.m_out);
        IOUtils.closeQuietly(this.m_in);
        IOUtils.closeQuietly(this.m_socket);
    }

    public static void closeQuietly(TransportClient p_client) {
        if (p_client != null) {
            p_client.close();
        }
    }
}

