/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxd.client;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.client.TransportClient;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.params.LicenseStatusParams;
import org.xdi.oxd.common.response.LicenseStatusOpResponse;

public class CommandClient {
    private static final Logger LOG = LoggerFactory.getLogger(CoreUtils.class);
    private TransportClient m_client;

    public CommandClient(String host, int port) throws IOException {
        this.m_client = new TransportClient(host, port);
    }

    public CommandResponse send(Command p_command) {
        if (p_command == null) {
            throw new IllegalArgumentException("Command is null");
        }
        try {
            String commandAsJson = CoreUtils.asJson(p_command);
            String responseAsJson = this.m_client.sendCommand(commandAsJson);
            if (StringUtils.isNotBlank(responseAsJson)) {
                return CoreUtils.createJsonMapper().readValue(responseAsJson, CommandResponse.class);
            }
            LOG.error("Server doesn't send any response.");
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
        return null;
    }

    public void close() {
        if (this.m_client != null) {
            this.m_client.close();
        }
    }

    public static void closeQuietly(CommandClient p_client) {
        if (p_client != null) {
            p_client.close();
        }
    }

    public LicenseStatusOpResponse licenseStatus() {
        Command command = new Command(CommandType.LICENSE_STATUS);
        command.setParamsObject(new LicenseStatusParams());
        CommandResponse response = this.send(command);
        return response.dataAsResponse(LicenseStatusOpResponse.class);
    }
}

