/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.OxElevenCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jwk.KeyType;
import org.xdi.oxauth.model.jwk.Use;
import org.xdi.oxauth.model.util.SecurityProviderUtility;
import org.xdi.oxauth.model.util.StringUtils;

public class KeyGenerator {
    private static final String ALGORITHMS = "algorithms";
    private static final String KEY_STORE_FILE = "keystore";
    private static final String KEY_STORE_PASSWORD = "keypasswd";
    private static final String DN_NAME = "dnname";
    private static final String OXELEVEN_GENERATE_KEY_ENDPOINT = "ox11";
    private static final String EXPIRATION = "expiration";
    private static final String HELP = "h";
    private static final Logger log;

    public static void main(String[] args) throws Exception {
        new Cli(args).parse();
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        log = Logger.getLogger(KeyGenerator.class);
    }

    public static class Cli {
        private String[] args = null;
        private Options options = new Options();

        public Cli(String[] args) {
            this.args = args;
            Option algorithmsOption = new Option(KeyGenerator.ALGORITHMS, true, "Signature Algorithms (RS256 RS384 RS512 ES256 ES384 ES512).");
            algorithmsOption.setArgs(-2);
            this.options.addOption(algorithmsOption);
            this.options.addOption(KeyGenerator.KEY_STORE_FILE, true, "Key Store file.");
            this.options.addOption(KeyGenerator.KEY_STORE_PASSWORD, true, "Key Store password.");
            this.options.addOption(KeyGenerator.DN_NAME, true, "DN of certificate issuer.");
            this.options.addOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT, true, "oxEleven Generate Key Endpoint.");
            this.options.addOption(KeyGenerator.EXPIRATION, true, "Expiration in days.");
            this.options.addOption(KeyGenerator.HELP, false, "Show help.");
        }

        public void parse() {
            BasicParser parser = new BasicParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(this.options, this.args);
                if (cmd.hasOption(KeyGenerator.HELP)) {
                    this.help();
                }
                if (cmd.hasOption(KeyGenerator.ALGORITHMS) && cmd.hasOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT) && cmd.hasOption(KeyGenerator.EXPIRATION)) {
                    String[] algorithms = cmd.getOptionValues(KeyGenerator.ALGORITHMS);
                    String generateKeyEndpoint = cmd.getOptionValue(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT);
                    int expiration = Integer.parseInt(cmd.getOptionValue(KeyGenerator.EXPIRATION));
                    List<SignatureAlgorithm> signatureAlgorithms = SignatureAlgorithm.fromString(algorithms);
                    if (signatureAlgorithms.isEmpty()) {
                        this.help();
                    } else {
                        try {
                            JSONWebKeySet jwks = new JSONWebKeySet();
                            OxElevenCryptoProvider cryptoProvider = new OxElevenCryptoProvider(generateKeyEndpoint, null, null, null);
                            GregorianCalendar calendar = new GregorianCalendar();
                            ((Calendar)calendar).add(5, expiration);
                            for (SignatureAlgorithm signatureAlgorithm : signatureAlgorithms) {
                                JSONObject result = cryptoProvider.generateKey(signatureAlgorithm, calendar.getTimeInMillis());
                                JSONWebKey key = new JSONWebKey();
                                key.setKid(result.getString("kid"));
                                key.setUse(Use.SIGNATURE);
                                key.setAlg(signatureAlgorithm);
                                key.setKty(KeyType.fromString(signatureAlgorithm.getFamily()));
                                key.setExp(result.optLong("exp"));
                                key.setCrv(signatureAlgorithm.getCurve());
                                key.setN(result.optString("n"));
                                key.setE(result.optString("e"));
                                key.setX(result.optString("x"));
                                key.setY(result.optString("y"));
                                JSONArray x5c = result.optJSONArray("x5c");
                                key.setX5c(StringUtils.toList(x5c));
                                jwks.getKeys().add(key);
                            }
                            System.out.println(jwks);
                        }
                        catch (Exception e) {
                            log.error("Failed to generate keys", e);
                            this.help();
                        }
                    }
                } else if (cmd.hasOption(KeyGenerator.ALGORITHMS) && cmd.hasOption(KeyGenerator.KEY_STORE_FILE) && cmd.hasOption(KeyGenerator.KEY_STORE_PASSWORD) && cmd.hasOption(KeyGenerator.DN_NAME) && cmd.hasOption(KeyGenerator.EXPIRATION)) {
                    String[] algorithms = cmd.getOptionValues(KeyGenerator.ALGORITHMS);
                    String keystore = cmd.getOptionValue(KeyGenerator.KEY_STORE_FILE);
                    String keypasswd = cmd.getOptionValue(KeyGenerator.KEY_STORE_PASSWORD);
                    String dnName = cmd.getOptionValue(KeyGenerator.DN_NAME);
                    int expiration = Integer.parseInt(cmd.getOptionValue(KeyGenerator.EXPIRATION));
                    List<SignatureAlgorithm> signatureAlgorithms = SignatureAlgorithm.fromString(algorithms);
                    if (signatureAlgorithms.isEmpty()) {
                        this.help();
                    } else {
                        try {
                            SecurityProviderUtility.installBCProvider(true);
                            JSONWebKeySet jwks = new JSONWebKeySet();
                            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keystore, keypasswd, dnName);
                            GregorianCalendar calendar = new GregorianCalendar();
                            ((Calendar)calendar).add(5, expiration);
                            for (SignatureAlgorithm signatureAlgorithm : signatureAlgorithms) {
                                JSONObject result = cryptoProvider.generateKey(signatureAlgorithm, calendar.getTimeInMillis());
                                JSONWebKey key = new JSONWebKey();
                                key.setKid(result.getString("kid"));
                                key.setUse(Use.SIGNATURE);
                                key.setAlg(signatureAlgorithm);
                                key.setKty(KeyType.fromString(signatureAlgorithm.getFamily()));
                                key.setExp(result.optLong("exp"));
                                key.setCrv(signatureAlgorithm.getCurve());
                                key.setN(result.optString("n"));
                                key.setE(result.optString("e"));
                                key.setX(result.optString("x"));
                                key.setY(result.optString("y"));
                                JSONArray x5c = result.optJSONArray("x5c");
                                key.setX5c(StringUtils.toList(x5c));
                                jwks.getKeys().add(key);
                            }
                            System.out.println(jwks);
                        }
                        catch (Exception e) {
                            log.error("Failed to generate keys", e);
                            this.help();
                        }
                    }
                } else {
                    this.help();
                }
            }
            catch (ParseException e) {
                log.error("Failed to generate keys", e);
                this.help();
            }
        }

        private void help() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("KeyGenerator -algorithms alg ... -expiration n_days [-ox11 url] [-keystore path -keypasswd secret -dnname dn_name]", this.options);
            System.exit(0);
        }
    }
}

