/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma.persistence;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxauth.model.uma.persistence.InternalExternal;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthUmaScopeDescription"})
public class ScopeDescription {
    @LdapDN
    private String dn;
    @LdapAttribute(ignoreDuringUpdate=true)
    private String inum;
    @NotNull(message="Display name should be not empty")
    @LdapAttribute(name="displayName")
    private String displayName;
    @LdapAttribute(name="owner")
    private String owner;
    @LdapAttribute(name="oxFaviconImage")
    private String faviconImageAsXml;
    @NotNull
    @Size(min=4, max=30, message="Length of scope name should be between 4 and 30")
    @Pattern(regexp="^[a-zA-Z\\d_]{4,30}$", message="Invalid Scope Id .Only alphanumeric and underscore are allowed.")
    @LdapAttribute(name="oxId")
    private String id;
    @LdapAttribute(name="oxPolicyRule")
    private String policyRule;
    @LdapAttribute(name="oxRevision")
    private String revision;
    @LdapAttribute(name="oxIconUrl")
    private String iconUrl;
    @LdapAttribute(name="oxUrl")
    private String url;
    @LdapAttribute(name="oxType")
    private InternalExternal type;
    @LdapAttribute(name="oxPolicyScriptDn")
    private List<String> authorizationPolicies;

    public InternalExternal getType() {
        return this.type;
    }

    public void setType(InternalExternal p_type) {
        this.type = p_type;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String p_inum) {
        this.inum = p_inum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String p_displayName) {
        this.displayName = p_displayName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String p_owner) {
        this.owner = p_owner;
    }

    public String getFaviconImageAsXml() {
        return this.faviconImageAsXml;
    }

    public void setFaviconImageAsXml(String p_faviconImageAsXml) {
        this.faviconImageAsXml = p_faviconImageAsXml;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public String getPolicyRule() {
        return this.policyRule;
    }

    public void setPolicyRule(String p_policyRule) {
        this.policyRule = p_policyRule;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String p_revision) {
        this.revision = p_revision;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String p_iconUrl) {
        this.iconUrl = p_iconUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String p_url) {
        this.url = p_url;
    }

    public List<String> getAuthorizationPolicies() {
        return this.authorizationPolicies;
    }

    public void setAuthorizationPolicies(List<String> authorizationPolicies) {
        this.authorizationPolicies = authorizationPolicies;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScopeDescription [dn=").append(this.dn).append(", inum=").append(this.inum).append(", displayName=").append(this.displayName).append(", owner=").append(this.owner).append(", faviconImageAsXml=").append(this.faviconImageAsXml).append(", id=").append(this.id).append(", policyRule=").append(this.policyRule).append(", revision=").append(this.revision).append(", iconUrl=").append(this.iconUrl).append(", url=").append(this.url).append(", type=").append(this.type).append(", authorizationPolicies=").append(this.authorizationPolicies).append("]");
        return builder.toString();
    }
}

