/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma.persistence;

import java.util.Date;
import java.util.List;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxauth.model.uma.UmaPermission;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthUmaResourceSetPermission"})
public class ResourceSetPermission {
    @LdapDN
    private String dn;
    @LdapAttribute(name="oxAmHost")
    private String amHost;
    @LdapAttribute(name="oxHost")
    private String host;
    @LdapAttribute(name="oxTicket")
    private String ticket;
    @LdapAttribute(name="oxConfigurationCode")
    private String configurationCode;
    @LdapAttribute(name="oxAuthExpiration")
    private Date expirationDate;
    @LdapAttribute(name="oxResourceSetId")
    private String resourceSetId;
    @LdapAttribute(name="oxAuthUmaScope")
    private List<String> scopeDns;
    private boolean expired;

    public ResourceSetPermission() {
    }

    public ResourceSetPermission(String p_resourceSetId, List<String> p_scopes, String amHost, String host, String ticket, String configurationCode, Date expirationDate) {
        this.resourceSetId = p_resourceSetId;
        this.scopeDns = p_scopes;
        this.amHost = amHost;
        this.host = host;
        this.ticket = ticket;
        this.configurationCode = configurationCode;
        this.expirationDate = expirationDate;
        this.checkExpired();
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public void checkExpired() {
        this.checkExpired(new Date());
    }

    public void checkExpired(Date now) {
        if (now.after(this.expirationDate)) {
            this.expired = true;
        }
    }

    public boolean isValid() {
        return !this.expired;
    }

    public UmaPermission getResourceSetPermissionRequest() {
        return new UmaPermission(this.resourceSetId, this.scopeDns);
    }

    public String getAmHost() {
        return this.amHost;
    }

    public void setAmHost(String amHost) {
        this.amHost = amHost;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getConfigurationCode() {
        return this.configurationCode;
    }

    public void setConfigurationCode(String configurationCode) {
        this.configurationCode = configurationCode;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getResourceSetId() {
        return this.resourceSetId;
    }

    public void setResourceSetId(String p_resourceSetId) {
        this.resourceSetId = p_resourceSetId;
    }

    public List<String> getScopeDns() {
        return this.scopeDns;
    }

    public void setScopeDns(List<String> p_scopeDns) {
        this.scopeDns = p_scopeDns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSetPermission that = (ResourceSetPermission)o;
        return !(this.ticket == null ? that.ticket != null : !this.ticket.equals(that.ticket));
    }

    public int hashCode() {
        return this.ticket != null ? this.ticket.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceSetPermission");
        sb.append("{amHost='").append(this.amHost).append('\'');
        sb.append(", host='").append(this.host).append('\'');
        sb.append(", ticket='").append(this.ticket).append('\'');
        sb.append(", configurationCode='").append(this.configurationCode).append('\'');
        sb.append(", expirationDate=").append(this.expirationDate);
        sb.append(", expired=").append(this.expired);
        sb.append(", resourceSetId='").append(this.resourceSetId).append('\'');
        sb.append(", scopes=").append(this.scopeDns);
        sb.append('}');
        return sb.toString();
    }
}

