/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.jboss.resteasy.annotations.providers.jaxb.IgnoreMediaTypes;

@IgnoreMediaTypes(value={"application/*+json"})
@JsonPropertyOrder(value={"resource_set_id", "scopes", "exp", "iat", "nbf"})
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@ApiModel(value="Register permission request.")
public class UmaPermission
implements Serializable {
    @ApiModelProperty(value="The identifier for a resource set to which this client is seeking access. The identifier MUST correspond to a resource set that was previously registered.", required=true)
    private String resourceSetId;
    @ApiModelProperty(value="An array referencing one or more identifiers of scopes to which access is needed for this resource set. Each scope identifier MUST correspond to a scope that was registered by this resource server for the referenced resource set.", required=true)
    private List<String> scopes;
    private Date expiresAt;
    private Date issuedAt;
    private Date nbf;

    public UmaPermission() {
    }

    public UmaPermission(String p_resourceSetId, List<String> p_scopes) {
        this.resourceSetId = p_resourceSetId;
        this.scopes = p_scopes;
    }

    @JsonProperty(value="resource_set_id")
    @XmlElement(name="resource_set_id")
    public String getResourceSetId() {
        return this.resourceSetId;
    }

    public void setResourceSetId(String resourceSetId) {
        this.resourceSetId = resourceSetId;
    }

    @JsonProperty(value="nbf")
    @XmlElement(name="nbf")
    public Date getNbf() {
        return this.nbf;
    }

    public void setNbf(Date nbf) {
        this.nbf = nbf;
    }

    @JsonProperty(value="iat")
    @XmlElement(name="iat")
    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
    }

    @JsonProperty(value="scopes")
    @XmlElement(name="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @JsonProperty(value="exp")
    @XmlElement(name="exp")
    public Date getExpiresAt() {
        return this.expiresAt != null ? new Date(this.expiresAt.getTime()) : null;
    }

    public void setExpiresAt(Date p_expiresAt) {
        this.expiresAt = p_expiresAt != null ? new Date(p_expiresAt.getTime()) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceSetPermissionRequest");
        sb.append("{resourceSetId='").append(this.resourceSetId).append('\'');
        sb.append(", scopes=").append(this.scopes);
        sb.append(", expiresAt=").append(this.expiresAt);
        sb.append(", issuedAt=").append(this.issuedAt);
        sb.append(", nbf=").append(this.nbf);
        sb.append('}');
        return sb.toString();
    }
}

