/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jws;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.xdi.oxauth.model.crypto.Certificate;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.AbstractJwsSigner;
import org.xdi.oxauth.model.util.Base64Util;

public class RSASigner
extends AbstractJwsSigner {
    private RSAPrivateKey rsaPrivateKey;
    private RSAPublicKey rsaPublicKey;

    public RSASigner(SignatureAlgorithm signatureAlgorithm, RSAPrivateKey rsaPrivateKey) {
        super(signatureAlgorithm);
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public RSASigner(SignatureAlgorithm signatureAlgorithm, RSAPublicKey rsaPublicKey) {
        super(signatureAlgorithm);
        this.rsaPublicKey = rsaPublicKey;
    }

    public RSASigner(SignatureAlgorithm signatureAlgorithm, Certificate certificate) {
        super(signatureAlgorithm);
        this.rsaPublicKey = certificate.getRsaPublicKey();
    }

    @Override
    public String generateSignature(String signingInput) throws SignatureException {
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.rsaPrivateKey == null) {
            throw new SignatureException("The RSA private key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(this.rsaPrivateKey.getModulus(), this.rsaPrivateKey.getPrivateExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privateKey = keyFactory.generatePrivate(rsaPrivateKeySpec);
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            signature.initSign(privateKey);
            signature.update(signingInput.getBytes("UTF-8"));
            return Base64Util.base64urlencode(signature.sign());
        }
        catch (InvalidKeySpecException e) {
            throw new SignatureException(e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SignatureException(e);
        }
        catch (SignatureException e) {
            throw new SignatureException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateSignature(String signingInput, String signature) throws SignatureException {
        boolean bl;
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.rsaPublicKey == null) {
            throw new SignatureException("The RSA public key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        String algorithm = null;
        switch (this.getSignatureAlgorithm()) {
            case RS256: {
                algorithm = "SHA-256";
                break;
            }
            case RS384: {
                algorithm = "SHA-384";
                break;
            }
            case RS512: {
                algorithm = "SHA-512";
                break;
            }
            default: {
                throw new SignatureException("Unsupported signature algorithm");
            }
        }
        ASN1InputStream aIn = null;
        try {
            byte[] sigBytes = Base64Util.base64urldecode(signature);
            byte[] sigInBytes = signingInput.getBytes("UTF-8");
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(this.rsaPublicKey.getModulus(), this.rsaPublicKey.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
            Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
            cipher.init(2, publicKey);
            byte[] decSig = cipher.doFinal(sigBytes);
            aIn = new ASN1InputStream(decSig);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            MessageDigest hash = MessageDigest.getInstance(algorithm, "BC");
            hash.update(sigInBytes);
            ASN1OctetString sigHash = (ASN1OctetString)seq.getObjectAt(1);
            bl = MessageDigest.isEqual(hash.digest(), sigHash.getOctets());
        }
        catch (IOException e) {
            try {
                throw new SignatureException(e);
                catch (NoSuchAlgorithmException e2) {
                    throw new SignatureException(e2);
                }
                catch (InvalidKeyException e3) {
                    throw new SignatureException(e3);
                }
                catch (InvalidKeySpecException e4) {
                    throw new SignatureException(e4);
                }
                catch (NoSuchPaddingException e5) {
                    throw new SignatureException(e5);
                }
                catch (BadPaddingException e6) {
                    throw new SignatureException(e6);
                }
                catch (NoSuchProviderException e7) {
                    throw new SignatureException(e7);
                }
                catch (IllegalBlockSizeException e8) {
                    throw new SignatureException(e8);
                }
                catch (Exception e9) {
                    throw new SignatureException(e9);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(aIn);
        return bl;
    }
}

