/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwk.JSONWebKey;

public class JSONWebKeySet {
    private static final Logger LOG = Logger.getLogger(JSONWebKeySet.class);
    private List<JSONWebKey> keys = new ArrayList<JSONWebKey>();

    public List<JSONWebKey> getKeys() {
        return this.keys;
    }

    public void setKeys(List<JSONWebKey> keys) {
        this.keys = keys;
    }

    public JSONWebKey getKey(String keyId) {
        for (JSONWebKey jsonWebKey : this.keys) {
            if (!jsonWebKey.getKid().equals(keyId)) continue;
            return jsonWebKey;
        }
        return null;
    }

    @Deprecated
    public List<JSONWebKey> getKeys(SignatureAlgorithm algorithm) {
        ArrayList<JSONWebKey> jsonWebKeys = new ArrayList<JSONWebKey>();
        if ("RSA".equals(algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.keys) {
                if (!jsonWebKey.getAlg().equals(algorithm.getName())) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        } else if ("EC".equals(algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.keys) {
                if (!jsonWebKey.getAlg().equals(algorithm.getName())) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        }
        Collections.sort(jsonWebKeys);
        return jsonWebKeys;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONArray keys = new JSONArray();
        for (JSONWebKey key : this.getKeys()) {
            JSONObject jsonKeyValue = key.toJSONObject();
            keys.put(jsonKeyValue);
        }
        jsonObj.put("keys", keys);
        return jsonObj;
    }

    public String toString() {
        try {
            JSONObject jwks = this.toJSONObject();
            return jwks.toString(4).replace("\\/", "/");
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public static JSONWebKeySet fromJSONObject(JSONObject jwksJSONObject) throws JSONException {
        JSONWebKeySet jwks = new JSONWebKeySet();
        JSONArray jwksJsonArray = jwksJSONObject.getJSONArray("keys");
        for (int i = 0; i < jwksJsonArray.length(); ++i) {
            JSONObject jwkJsonObject = jwksJsonArray.getJSONObject(i);
            JSONWebKey jwk = JSONWebKey.fromJSONObject(jwkJsonObject);
            jwks.getKeys().add(jwk);
        }
        return jwks;
    }
}

