/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwe;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidParameterException;
import org.xdi.oxauth.model.jwe.AbstractJweEncrypter;
import org.xdi.oxauth.model.jwe.KeyDerivationFunction;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.model.util.Pair;

public class JweEncrypterImpl
extends AbstractJweEncrypter {
    private PublicKey publicKey;
    private byte[] sharedSymmetricKey;

    public JweEncrypterImpl(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, byte[] sharedSymmetricKey) {
        super(keyEncryptionAlgorithm, blockEncryptionAlgorithm);
        if (sharedSymmetricKey != null) {
            this.sharedSymmetricKey = (byte[])sharedSymmetricKey.clone();
        }
    }

    public JweEncrypterImpl(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, PublicKey publicKey) {
        super(keyEncryptionAlgorithm, blockEncryptionAlgorithm);
        this.publicKey = publicKey;
    }

    @Override
    public String generateEncryptedKey(byte[] contentMasterKey) throws InvalidJweException {
        if (this.getKeyEncryptionAlgorithm() == null) {
            throw new InvalidJweException("The key encryption algorithm is null");
        }
        if (contentMasterKey == null) {
            throw new InvalidJweException("The content master key (CMK) is null");
        }
        try {
            if (this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.RSA_OAEP || this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.RSA1_5) {
                if (this.publicKey != null) {
                    Cipher cipher = Cipher.getInstance(this.getKeyEncryptionAlgorithm().getAlgorithm(), "BC");
                    cipher.init(1, this.publicKey);
                    byte[] encryptedKey = cipher.doFinal(contentMasterKey);
                    String encodedEncryptedKey = Base64Util.base64urlencode(encryptedKey);
                    return encodedEncryptedKey;
                }
                throw new InvalidJweException("The RSA public key is null");
            }
            if (this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.A128KW || this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.A256KW) {
                if (this.sharedSymmetricKey == null) {
                    throw new InvalidJweException("The shared symmetric key is null");
                }
                if (this.sharedSymmetricKey.length != 16) {
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    this.sharedSymmetricKey = sha.digest(this.sharedSymmetricKey);
                    this.sharedSymmetricKey = Arrays.copyOf(this.sharedSymmetricKey, 16);
                }
                SecretKeySpec keyEncryptionKey = new SecretKeySpec(this.sharedSymmetricKey, "AES");
                AESWrapEngine aesWrapEngine = new AESWrapEngine();
                KeyParameter params = new KeyParameter(keyEncryptionKey.getEncoded());
                aesWrapEngine.init(true, params);
                byte[] wrappedKey = aesWrapEngine.wrap(contentMasterKey, 0, contentMasterKey.length);
                String encodedEncryptedKey = Base64Util.base64urlencode(wrappedKey);
                return encodedEncryptedKey;
            }
            throw new InvalidJweException("The key encryption algorithm is not supported");
        }
        catch (NoSuchPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidJweException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidJweException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidJweException(e);
        }
    }

    @Override
    public Pair<String, String> generateCipherTextAndIntegrityValue(byte[] contentMasterKey, byte[] initializationVector, byte[] additionalAuthenticatedData, byte[] plainText) throws InvalidJweException {
        if (this.getBlockEncryptionAlgorithm() == null) {
            throw new InvalidJweException("The block encryption algorithm is null");
        }
        if (contentMasterKey == null) {
            throw new InvalidJweException("The content master key (CMK) is null");
        }
        if (initializationVector == null) {
            throw new InvalidJweException("The initialization vector is null");
        }
        if (additionalAuthenticatedData == null) {
            throw new InvalidJweException("The additional authentication data is null");
        }
        if (plainText == null) {
            throw new InvalidJweException("The plain text to encrypt is null");
        }
        try {
            if (this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A128GCM || this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A256GCM) {
                SecretKeySpec secretKey = new SecretKeySpec(contentMasterKey, "AES");
                KeyParameter key = new KeyParameter(contentMasterKey);
                int MAC_SIZE_BITS = 128;
                AEADParameters aeadParameters = new AEADParameters(key, 128, initializationVector, additionalAuthenticatedData);
                int macSize = aeadParameters.getMacSize() / 8;
                AESEngine blockCipher = new AESEngine();
                KeyParameter params = new KeyParameter(secretKey.getEncoded());
                blockCipher.init(true, params);
                GCMBlockCipher aGCMBlockCipher = new GCMBlockCipher(blockCipher);
                aGCMBlockCipher.init(true, aeadParameters);
                int len = aGCMBlockCipher.getOutputSize(plainText.length);
                byte[] out = new byte[len];
                int outOff = aGCMBlockCipher.processBytes(plainText, 0, plainText.length, out, 0);
                outOff += aGCMBlockCipher.doFinal(out, outOff);
                byte[] cipherText = new byte[outOff - macSize];
                System.arraycopy(out, 0, cipherText, 0, cipherText.length);
                byte[] authenticationTag = new byte[macSize];
                System.arraycopy(out, outOff - macSize, authenticationTag, 0, authenticationTag.length);
                String encodedCipherText = Base64Util.base64urlencode(cipherText);
                String encodedAuthenticationTag = Base64Util.base64urlencode(authenticationTag);
                return new Pair<String, String>(encodedCipherText, encodedAuthenticationTag);
            }
            if (this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 || this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A256CBC_PLUS_HS512) {
                byte[] cek = KeyDerivationFunction.generateCek(contentMasterKey, this.getBlockEncryptionAlgorithm());
                IvParameterSpec parameters = new IvParameterSpec(initializationVector);
                Cipher cipher = Cipher.getInstance(this.getBlockEncryptionAlgorithm().getAlgorithm(), "BC");
                SecretKeySpec secretKeySpec = new SecretKeySpec(cek, "AES");
                cipher.init(1, (Key)secretKeySpec, parameters);
                byte[] cipherText = cipher.doFinal(plainText);
                String encodedCipherText = Base64Util.base64urlencode(cipherText);
                String securedInputValue = new String(additionalAuthenticatedData, Charset.forName("UTF-8")) + "." + encodedCipherText;
                byte[] cik = KeyDerivationFunction.generateCik(contentMasterKey, this.getBlockEncryptionAlgorithm());
                SecretKeySpec secretKey = new SecretKeySpec(cik, this.getBlockEncryptionAlgorithm().getIntegrityValueAlgorithm());
                Mac mac = Mac.getInstance(this.getBlockEncryptionAlgorithm().getIntegrityValueAlgorithm());
                mac.init(secretKey);
                byte[] integrityValue = mac.doFinal(securedInputValue.getBytes("UTF-8"));
                String encodedIntegrityValue = Base64Util.base64urlencode(integrityValue);
                return new Pair<String, String>(encodedCipherText, encodedIntegrityValue);
            }
            throw new InvalidJweException("The block encryption algorithm is not supported");
        }
        catch (InvalidCipherTextException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidJweException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidJweException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidJweException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidParameterException e) {
            throw new InvalidJweException(e);
        }
    }
}

