/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwe;

import java.security.PrivateKey;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.JweDecrypterImpl;
import org.xdi.oxauth.model.token.JsonWebResponse;

public class Jwe
extends JsonWebResponse {
    private String encodedHeader = null;
    private String encodedEncryptedKey = null;
    private String encodedInitializationVector = null;
    private String encodedCiphertext = null;
    private String encodedIntegrityValue = null;

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public void setEncodedHeader(String encodedHeader) {
        this.encodedHeader = encodedHeader;
    }

    public String getEncodedEncryptedKey() {
        return this.encodedEncryptedKey;
    }

    public void setEncodedEncryptedKey(String encodedEncryptedKey) {
        this.encodedEncryptedKey = encodedEncryptedKey;
    }

    public String getEncodedInitializationVector() {
        return this.encodedInitializationVector;
    }

    public void setEncodedInitializationVector(String encodedInitializationVector) {
        this.encodedInitializationVector = encodedInitializationVector;
    }

    public String getEncodedCiphertext() {
        return this.encodedCiphertext;
    }

    public void setEncodedCiphertext(String encodedCiphertext) {
        this.encodedCiphertext = encodedCiphertext;
    }

    public String getEncodedIntegrityValue() {
        return this.encodedIntegrityValue;
    }

    public void setEncodedIntegrityValue(String encodedIntegrityValue) {
        this.encodedIntegrityValue = encodedIntegrityValue;
    }

    public String getAdditionalAuthenticatedData() {
        String additionalAuthenticatedData = this.encodedHeader + "." + this.encodedEncryptedKey + "." + this.encodedInitializationVector;
        return additionalAuthenticatedData;
    }

    public static Jwe parse(String encodedJwe, PrivateKey privateKey, byte[] sharedSymmetricKey) throws InvalidJweException, InvalidJwtException {
        Jwe jwe = null;
        if (privateKey != null) {
            JweDecrypterImpl jweDecrypter = new JweDecrypterImpl(privateKey);
            jwe = jweDecrypter.decrypt(encodedJwe);
        } else if (sharedSymmetricKey != null) {
            JweDecrypterImpl jweDecrypter = new JweDecrypterImpl(sharedSymmetricKey);
            jwe = jweDecrypter.decrypt(encodedJwe);
        }
        return jwe;
    }

    @Override
    public String toString() {
        return this.encodedHeader + "." + this.encodedEncryptedKey + "." + this.encodedInitializationVector + "." + this.encodedCiphertext + "." + this.encodedIntegrityValue;
    }
}

