/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwe;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwe.JweEncrypter;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.model.util.Pair;

public abstract class AbstractJweEncrypter
implements JweEncrypter {
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    private BlockEncryptionAlgorithm blockEncryptionAlgorithm;

    protected AbstractJweEncrypter(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public BlockEncryptionAlgorithm getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    @Override
    public Jwe encrypt(Jwe jwe) throws InvalidJweException {
        try {
            jwe.setEncodedHeader(jwe.getHeader().toBase64JsonObject());
            byte[] contentMasterKey = new byte[this.blockEncryptionAlgorithm.getCmkLength() / 8];
            SecureRandom random = new SecureRandom();
            random.nextBytes(contentMasterKey);
            String encodedEncryptedKey = this.generateEncryptedKey(contentMasterKey);
            jwe.setEncodedEncryptedKey(encodedEncryptedKey);
            byte[] initializationVector = new byte[this.blockEncryptionAlgorithm.getInitVectorLength() / 8];
            random.nextBytes(initializationVector);
            String encodedInitializationVector = Base64Util.base64urlencode(initializationVector);
            jwe.setEncodedInitializationVector(encodedInitializationVector);
            Pair<String, String> result = this.generateCipherTextAndIntegrityValue(contentMasterKey, initializationVector, jwe.getAdditionalAuthenticatedData().getBytes("UTF-8"), jwe.getClaims().toBase64JsonObject().getBytes("UTF-8"));
            jwe.setEncodedCiphertext(result.getFirst());
            jwe.setEncodedIntegrityValue(result.getSecond());
            return jwe;
        }
        catch (InvalidJwtException e) {
            throw new InvalidJweException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException(e);
        }
    }

    public abstract String generateEncryptedKey(byte[] var1) throws InvalidJweException;

    public abstract Pair<String, String> generateCipherTextAndIntegrityValue(byte[] var1, byte[] var2, byte[] var3, byte[] var4) throws InvalidJweException;
}

