/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.xdi.oxauth.model.crypto.signature.ECEllipticCurve;
import org.xdi.oxauth.model.jwt.JwtType;

public enum SignatureAlgorithm {
    NONE("none"),
    HS256("HS256", "HMAC", "HMACSHA256"),
    HS384("HS384", "HMAC", "HMACSHA384"),
    HS512("HS512", "HMAC", "HMACSHA512"),
    RS256("RS256", "RSA", "SHA256WITHRSA"),
    RS384("RS384", "RSA", "SHA384WITHRSA"),
    RS512("RS512", "RSA", "SHA512WITHRSA"),
    ES256("ES256", "EC", "SHA256WITHECDSA", ECEllipticCurve.P_256),
    ES384("ES384", "EC", "SHA384WITHECDSA", ECEllipticCurve.P_384),
    ES512("ES512", "EC", "SHA512WITHECDSA", ECEllipticCurve.P_521);

    private final String name;
    private final String family;
    private final String algorithm;
    private final ECEllipticCurve curve;
    private final JwtType jwtType;

    private SignatureAlgorithm(String name, String family, String algorithm, ECEllipticCurve curve) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.curve = curve;
        this.jwtType = JwtType.JWT;
    }

    private SignatureAlgorithm(String name, String family, String algorithm) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.curve = null;
        this.jwtType = JwtType.JWT;
    }

    private SignatureAlgorithm(String name) {
        this.name = name;
        this.family = null;
        this.algorithm = null;
        this.curve = null;
        this.jwtType = JwtType.JWT;
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public ECEllipticCurve getCurve() {
        return this.curve;
    }

    public JwtType getJwtType() {
        return this.jwtType;
    }

    public static List<SignatureAlgorithm> fromString(String[] params) {
        ArrayList<SignatureAlgorithm> signatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        for (String param : params) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString(param);
            if (signatureAlgorithm == null) continue;
            signatureAlgorithms.add(signatureAlgorithm);
        }
        return signatureAlgorithms;
    }

    @JsonCreator
    public static SignatureAlgorithm fromString(String param) {
        if (param != null) {
            for (SignatureAlgorithm sa : SignatureAlgorithm.values()) {
                if (!param.equals(sa.name)) continue;
                return sa;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

