/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.xdi.oxauth.model.crypto.signature.AbstractSigner;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.util.Base64Util;

public class RSASigner
extends AbstractSigner {
    private RSAPrivateKey rsaPrivateKey;
    private RSAPublicKey rsaPublicKey;

    public RSASigner(SignatureAlgorithm signatureAlgorithm, RSAPrivateKey rsaPrivateKey) throws Exception {
        this(signatureAlgorithm);
        if (rsaPrivateKey == null) {
            throw new Exception("Invalid RSA private key");
        }
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public RSASigner(SignatureAlgorithm signatureAlgorithm, RSAPublicKey rsaPublicKey) throws Exception {
        this(signatureAlgorithm);
        if (rsaPublicKey == null) {
            throw new Exception("Invalid RSA public key");
        }
        this.rsaPublicKey = rsaPublicKey;
    }

    private RSASigner(SignatureAlgorithm signatureAlgorithm) throws Exception {
        super(signatureAlgorithm);
        if (signatureAlgorithm == null || !"RSA".equals(signatureAlgorithm.getFamily())) {
            throw new Exception("Invalid signature algorithm");
        }
    }

    @Override
    public String sign(String signingInput) throws Exception {
        if (Strings.isNullOrEmpty(signingInput)) {
            throw new Exception("Invalid signing input");
        }
        try {
            RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(this.rsaPrivateKey.getModulus(), this.rsaPrivateKey.getPrivateExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privateKey = keyFactory.generatePrivate(rsaPrivateKeySpec);
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            signature.initSign(privateKey);
            signature.update(signingInput.getBytes("UTF-8"));
            return Base64Util.base64urlencode(signature.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("There was a problem in RSA signing", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("There was a problem in RSA signing", e);
        }
        catch (SignatureException e) {
            throw new Exception("There was a problem in RSA signing", e);
        }
        catch (NoSuchProviderException e) {
            throw new Exception("There was a problem in RSA signing", e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("There was a problem in RSA signing", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("There was a problem in RSA signing", e);
        }
    }

    @Override
    public boolean verifySignature(String signingInput, String signature) throws Exception {
        if (Strings.isNullOrEmpty(signingInput)) {
            return false;
        }
        if (Strings.isNullOrEmpty(signature)) {
            return false;
        }
        try {
            byte[] signatureBytes = Base64Util.base64urldecode(signature);
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(this.rsaPublicKey.getModulus(), this.rsaPublicKey.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
            Signature verifier = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            verifier.initVerify(publicKey);
            verifier.update(signingInput.getBytes());
            return verifier.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("There was a problem in RSA verifier", e);
        }
        catch (SignatureException e) {
            throw new Exception("There was a problem in RSA verifier", e);
        }
        catch (NoSuchProviderException e) {
            throw new Exception("There was a problem in RSA verifier", e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("There was a problem in RSA verifier", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("There was a problem in RSA verifier", e);
        }
    }
}

