/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import java.math.BigInteger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.PrivateKey;
import org.xdi.oxauth.model.util.Base64Util;

public class RSAPrivateKey
extends PrivateKey {
    private BigInteger modulus;
    private BigInteger privateExponent;

    public RSAPrivateKey(BigInteger modulus, BigInteger privateExponent) {
        this.modulus = modulus;
        this.privateExponent = privateExponent;
    }

    public RSAPrivateKey(String modulus, String privateExponent) {
        this.modulus = new BigInteger(1, Base64Util.base64urldecode(modulus));
        this.privateExponent = new BigInteger(1, Base64Util.base64urldecode(privateExponent));
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public void setModulus(BigInteger modulus) {
        this.modulus = modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public void setPrivateExponent(BigInteger privateExponent) {
        this.privateExponent = privateExponent;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", Base64Util.base64urlencodeUnsignedBigInt(this.modulus));
        jsonObject.put("e", Base64Util.base64urlencodeUnsignedBigInt(this.privateExponent));
        jsonObject.put("d", JSONObject.NULL);
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (JSONException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

