/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.xdi.oxauth.model.crypto.signature.AbstractSigner;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.util.Base64Util;

public class HMACSigner
extends AbstractSigner {
    private String sharedSecret;

    public HMACSigner(SignatureAlgorithm signatureAlgorithm, String sharedSecret) throws Exception {
        super(signatureAlgorithm);
        if (signatureAlgorithm == null || !"HMAC".equals(signatureAlgorithm.getFamily())) {
            throw new Exception("Invalid signature algorithm");
        }
        if (Strings.isNullOrEmpty(sharedSecret)) {
            throw new Exception("Invalid shared secret");
        }
        this.sharedSecret = sharedSecret;
    }

    @Override
    public String sign(String signingInput) throws Exception {
        if (Strings.isNullOrEmpty(signingInput)) {
            throw new Exception("Invalid signing input");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(this.sharedSecret.getBytes("UTF-8"), this.getSignatureAlgorithm().getAlgorithm());
            Mac mac = Mac.getInstance(this.getSignatureAlgorithm().getAlgorithm());
            mac.init(secretKey);
            byte[] sig = mac.doFinal(signingInput.getBytes("UTF-8"));
            return Base64Util.base64urlencode(sig);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("There was a problem in HMAC signing", e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("There was a problem in HMAC signing", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("There was a problem in HMAC signing", e);
        }
    }

    @Override
    public boolean verifySignature(String signingInput, String signature) throws Exception {
        if (Strings.isNullOrEmpty(signingInput)) {
            return false;
        }
        if (Strings.isNullOrEmpty(signature)) {
            return false;
        }
        String expectedSignature = this.sign(signingInput);
        return expectedSignature.equals(signature);
    }
}

