/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.xdi.oxauth.model.crypto.signature.AbstractSigner;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.util.Base64Util;

@Deprecated
public class ECSigner
extends AbstractSigner {
    private ECDSAPrivateKey ecdsaPrivateKey;
    private ECDSAPublicKey ecdsaPublicKey;

    @Deprecated
    public ECSigner(SignatureAlgorithm signatureAlgorithm, ECDSAPrivateKey ecdsaPrivateKey) throws Exception {
        super(signatureAlgorithm);
        if (ecdsaPrivateKey == null) {
            throw new Exception("Invalid EC private key");
        }
        this.ecdsaPrivateKey = ecdsaPrivateKey;
    }

    @Deprecated
    public ECSigner(SignatureAlgorithm signatureAlgorithm, ECDSAPublicKey ecdsaPublicKey) throws Exception {
        super(signatureAlgorithm);
        if (ecdsaPublicKey == null) {
            throw new Exception("Invalid EC private key");
        }
        this.ecdsaPublicKey = ecdsaPublicKey;
    }

    @Deprecated
    private ECSigner(SignatureAlgorithm signatureAlgorithm) throws Exception {
        super(signatureAlgorithm);
        if (signatureAlgorithm == null || !"EC".equals(signatureAlgorithm.getFamily())) {
            throw new Exception("Invalid signature algorithm");
        }
    }

    @Override
    @Deprecated
    public String sign(String signingInput) throws Exception {
        if (Strings.isNullOrEmpty(signingInput)) {
            throw new Exception("Invalid signing input");
        }
        try {
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec(this.getSignatureAlgorithm().getCurve().getName());
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(this.ecdsaPrivateKey.getD(), ecSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            signature.initSign(privateKey);
            signature.update(signingInput.getBytes("UTF-8"));
            return Base64Util.base64urlencode(signature.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("There was a problem in EC signing", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("There was a problem in EC signing", e);
        }
        catch (SignatureException e) {
            throw new Exception("There was a problem in EC signing", e);
        }
        catch (NoSuchProviderException e) {
            throw new Exception("There was a problem in EC signing", e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("There was a problem in EC signing", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("There was a problem in EC signing", e);
        }
    }

    @Override
    @Deprecated
    public boolean verifySignature(String signingInput, String signature) throws Exception {
        if (Strings.isNullOrEmpty(signingInput)) {
            return false;
        }
        if (Strings.isNullOrEmpty(signature)) {
            return false;
        }
        try {
            byte[] sigBytes = Base64Util.base64urldecode(signature);
            byte[] sigInBytes = signingInput.getBytes("UTF-8");
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec(this.getSignatureAlgorithm().getCurve().getName());
            BigInteger q = ((ECCurve.Fp)ecSpec.getCurve()).getQ();
            ECFieldElement.Fp xFieldElement = new ECFieldElement.Fp(q, this.ecdsaPublicKey.getX());
            ECFieldElement.Fp yFieldElement = new ECFieldElement.Fp(q, this.ecdsaPublicKey.getY());
            ECPoint.Fp pointQ = new ECPoint.Fp(ecSpec.getCurve(), xFieldElement, yFieldElement);
            ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(pointQ, ecSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sig = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            sig.initVerify(publicKey);
            sig.update(sigInBytes);
            return sig.verify(sigBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("There was a problem in EC verifier", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("There was a problem in EC verifier", e);
        }
        catch (SignatureException e) {
            throw new Exception("There was a problem in EC verifier", e);
        }
        catch (NoSuchProviderException e) {
            throw new Exception("There was a problem in EC verifier", e);
        }
        catch (InvalidKeyException e) {
            throw new Exception("There was a problem in EC verifier", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("There was a problem in EC verifier", e);
        }
    }
}

