/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.xdi.oxauth.model.crypto.Certificate;
import org.xdi.oxauth.model.crypto.KeyFactory;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;

public class ECDSAKeyFactory
extends KeyFactory<ECDSAPrivateKey, ECDSAPublicKey> {
    private SignatureAlgorithm signatureAlgorithm;
    private KeyPair keyPair;
    private ECDSAPrivateKey ecdsaPrivateKey;
    private ECDSAPublicKey ecdsaPublicKey;
    private Certificate certificate;

    public ECDSAKeyFactory(SignatureAlgorithm signatureAlgorithm, String dnName) throws InvalidParameterException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, CertificateEncodingException {
        if (signatureAlgorithm == null) {
            throw new InvalidParameterException("The signature algorithm cannot be null");
        }
        this.signatureAlgorithm = signatureAlgorithm;
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec(signatureAlgorithm.getCurve().getName());
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", "BC");
        keyGen.initialize(ecSpec, new SecureRandom());
        this.keyPair = keyGen.generateKeyPair();
        BCECPrivateKey privateKeySpec = (BCECPrivateKey)this.keyPair.getPrivate();
        BCECPublicKey publicKeySpec = (BCECPublicKey)this.keyPair.getPublic();
        BigInteger x = publicKeySpec.getQ().getX().toBigInteger();
        BigInteger y = publicKeySpec.getQ().getY().toBigInteger();
        BigInteger d = privateKeySpec.getD();
        this.ecdsaPrivateKey = new ECDSAPrivateKey(d);
        this.ecdsaPublicKey = new ECDSAPublicKey(signatureAlgorithm, x, y);
        if (StringUtils.isNotBlank(dnName)) {
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar expiryDate = new GregorianCalendar();
            expiryDate.add(1, 1);
            BigInteger serialNumber = new BigInteger(1024, new Random());
            X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
            X500Principal principal = new X500Principal(dnName);
            certGen.setSerialNumber(serialNumber);
            certGen.setIssuerDN(principal);
            certGen.setNotBefore(startDate.getTime());
            certGen.setNotAfter(expiryDate.getTime());
            certGen.setSubjectDN(principal);
            certGen.setPublicKey(this.keyPair.getPublic());
            certGen.setSignatureAlgorithm("SHA256WITHECDSA");
            X509Certificate x509Certificate = certGen.generate((PrivateKey)privateKeySpec, "BC");
            this.certificate = new Certificate(signatureAlgorithm, x509Certificate);
        }
    }

    public Certificate generateV3Certificate(Date startDate, Date expirationDate, String dnName) throws CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        BigInteger serialNumber = new BigInteger(1024, new Random());
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal principal = new X500Principal(dnName);
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(principal);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expirationDate);
        certGen.setSubjectDN(principal);
        certGen.setPublicKey(this.keyPair.getPublic());
        certGen.setSignatureAlgorithm(this.signatureAlgorithm.getAlgorithm());
        X509Certificate x509Certificate = certGen.generate(this.keyPair.getPrivate(), "BC");
        return new Certificate(this.signatureAlgorithm, x509Certificate);
    }

    @Override
    public ECDSAPrivateKey getPrivateKey() {
        return this.ecdsaPrivateKey;
    }

    @Override
    public ECDSAPublicKey getPublicKey() {
        return this.ecdsaPublicKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }
}

