/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.HashMap;
import java.util.Map;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;

public enum ScopeType implements LdapEnum
{
    OPENID("openid", "Openid"),
    DYNAMIC("dynamic", "Dynamic"),
    OAUTH("oauth", "OAuth");

    private final String value;
    private final String displayName;
    private static Map<String, ScopeType> mapByValues;

    private ScopeType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public static ScopeType fromString(String param) {
        return ScopeType.getByValue(param);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ScopeType getByValue(String value) {
        return mapByValues.get(value);
    }

    @Override
    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return ScopeType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, ScopeType>();
        for (ScopeType enumType : ScopeType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

