/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.xdi.oxauth.model.common.HasParamName;

public enum GrantType implements HasParamName,
LdapEnum
{
    AUTHORIZATION_CODE("authorization_code"),
    IMPLICIT("implicit"),
    RESOURCE_OWNER_PASSWORD_CREDENTIALS("password"),
    CLIENT_CREDENTIALS("client_credentials"),
    REFRESH_TOKEN("refresh_token"),
    EXTENSION,
    OXAUTH_EXCHANGE_TOKEN("oxauth_exchange_token");

    private final String value;
    private String uri;
    private static Map<String, GrantType> mapByValues;

    private GrantType() {
        this.value = null;
    }

    private GrantType(String value) {
        this.value = value;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static GrantType fromString(String param) {
        if (param != null) {
            for (GrantType gt : GrantType.values()) {
                if (!param.equals(gt.value)) continue;
                return gt;
            }
            try {
                URI.create(param);
                GrantType extension = EXTENSION;
                extension.uri = param;
                return extension;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static GrantType getByValue(String value) {
        return mapByValues.get(value);
    }

    @Override
    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return GrantType.getByValue(value);
    }

    public String toString() {
        if (this == EXTENSION) {
            return this.uri;
        }
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, GrantType>();
        for (GrantType enumType : GrantType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

