/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ValidateTokenRequest;
import org.xdi.oxauth.client.ValidateTokenResponse;
import org.xdi.oxauth.model.token.ValidateTokenErrorResponseType;

public class ValidateTokenClient
extends BaseClient<ValidateTokenRequest, ValidateTokenResponse> {
    private static final String mediaType = "application/json";
    private String httpMethod = "GET";

    public ValidateTokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        if ("GET".equals(httpMethod) || "POST".equals(httpMethod)) {
            this.httpMethod = httpMethod;
        }
    }

    public ValidateTokenResponse execValidateToken(String accessToken) {
        this.setRequest(new ValidateTokenRequest());
        ((ValidateTokenRequest)this.getRequest()).setAccessToken(accessToken);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidateTokenResponse exec() {
        this.initClientRequest();
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (StringUtils.isNotBlank(((ValidateTokenRequest)this.getRequest()).getAccessToken())) {
            this.clientRequest.queryParameter("access_token", ((ValidateTokenRequest)this.getRequest()).getAccessToken());
        }
        try {
            this.clientResponse = "GET".equals(this.getHttpMethod()) ? this.clientRequest.get(String.class) : this.clientRequest.post(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new ValidateTokenResponse(status));
            ((ValidateTokenResponse)this.getResponse()).setHeaders(this.clientResponse.getMetadata());
            String entity = this.clientResponse.getEntity(String.class);
            ((ValidateTokenResponse)this.getResponse()).setEntity(entity);
            if (entity != null && !entity.isEmpty()) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("valid")) {
                    ((ValidateTokenResponse)this.getResponse()).setValid(jsonObj.getBoolean("valid"));
                }
                if (jsonObj.has("expires_in")) {
                    ((ValidateTokenResponse)this.getResponse()).setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("error")) {
                    ((ValidateTokenResponse)this.getResponse()).setErrorType(ValidateTokenErrorResponseType.fromString(jsonObj.getString("error")));
                }
                if (jsonObj.has("error_description")) {
                    ((ValidateTokenResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                }
                if (jsonObj.has("error_uri")) {
                    ((ValidateTokenResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return (ValidateTokenResponse)this.getResponse();
    }
}

