/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.client.BaseRequest;

public class OpenIdConnectDiscoveryRequest
extends BaseRequest {
    private String resource;
    private String host;
    private String path;

    public OpenIdConnectDiscoveryRequest(String resource) throws URISyntaxException {
        this.resource = resource;
        if (StringUtils.isBlank(resource)) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (resource.startsWith("=") || resource.startsWith("@") || resource.startsWith("!")) {
            throw new UnsupportedOperationException("XRI is not supported");
        }
        if (resource.contains("@")) {
            this.host = resource.substring(resource.indexOf("@") + 1);
        } else {
            if (!resource.contains("://")) {
                resource = "https://" + resource;
            }
            URI uri = new URI(resource);
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.host = this.host + ":" + uri.getPort();
            }
            if (StringUtils.isNotBlank(uri.getPath()) && !uri.getPath().equals(uri.getHost()) && !uri.getPath().equals("/")) {
                this.path = uri.getPath();
            }
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            org.xdi.oxauth.model.util.StringUtils.addQueryStringParam(queryStringBuilder, "resource", this.resource);
            org.xdi.oxauth.model.util.StringUtils.addQueryStringParam(queryStringBuilder, "rel", "http://openid.net/specs/connect/1.0/issuer");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

