/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.client.BaseRequest;

public class EndSessionRequest
extends BaseRequest {
    private String idTokenHint;
    private String postLogoutRedirectUri;
    private String sessionState;
    private String state;

    public EndSessionRequest(String idTokenHint, String postLogoutRedirectUri, String state) {
        this.idTokenHint = idTokenHint;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        this.state = state;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setAccessToken(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String p_sessionState) {
        this.sessionState = p_sessionState;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            if (StringUtils.isNotBlank(this.idTokenHint)) {
                queryStringBuilder.append("id_token_hint").append("=").append(this.idTokenHint);
            }
            if (StringUtils.isNotBlank(this.postLogoutRedirectUri)) {
                queryStringBuilder.append("&").append("post_logout_redirect_uri").append("=").append(URLEncoder.encode(this.postLogoutRedirectUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank(this.state)) {
                queryStringBuilder.append("&").append("state").append("=").append(URLEncoder.encode(this.state, "UTF-8"));
            }
            if (StringUtils.isNotBlank(this.sessionState)) {
                queryStringBuilder.append("&").append("session_state").append("=").append(URLEncoder.encode(this.sessionState, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

