/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.model;

import java.util.HashMap;
import java.util.Map;

public enum AuthenticationMode {
    BASIC("basic", "Basic"),
    OAUTH("oauth", "OAuth"),
    UMA("uma", "UMA");

    private final String value;
    private final String displayName;
    private static final Map<String, AuthenticationMode> mapByValues;

    private AuthenticationMode(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public static AuthenticationMode getByValue(String value) {
        return mapByValues.get(value);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AuthenticationMode resolveByValue(String value) {
        return AuthenticationMode.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, AuthenticationMode>();
        for (AuthenticationMode enumType : AuthenticationMode.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

